/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.cfg.instr.InstrumentationConfig;
import com.atlassian.clover.cfg.instr.java.LanguageFeature;
import com.atlassian.clover.instr.Bindings;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationState;
import com.atlassian.clover.recorder.pertest.SnifferType;
import com_atlassian_clover.CloverProfile;
import com_atlassian_clover.CloverVersionInfo;
import com_atlassian_clover.CoverageRecorder;
import com_atlassian_clover.TestNameSniffer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class RecorderInstrEmitter
extends Emitter {
    static final String LAMBDA_INC_METHOD = "lambdaInc";
    static final String CASE_INC_METHOD = "caseInc";
    private static final String INCOMPATIBLE_MSG = "[CLOVER] WARNING: The Clover version used in instrumentation shall match the runtime version.";
    private static final String DEFAULT_CLASSNOTFOUND_MSG = "[CLOVER] FATAL ERROR: Clover could not be initialised. Are you sure you have Clover in the runtime classpath?";
    private static final String UNEXPECTED_MSG = "[CLOVER] FATAL ERROR: Clover could not be initialised because of an unexpected error.";
    private boolean isEnum;
    private boolean reportInitErrors;
    private boolean classInstrStrategy;
    private String recorderPrefix;
    private long recorderCfg;
    private String initString;
    private long registryVersion;
    private int maxDataIndex;
    private String javaLangPrefix;
    private boolean testClass;
    private boolean isSpockTestClass;
    private boolean isParameterizedJUnitTestClass;
    private InstrumentationStateView stateView;
    private String distributedConfig;
    private String classNotFoundMsg;
    private boolean shouldEmitWarningMethod;
    private List<CloverProfile> profiles;
    private boolean areLambdasSupported;
    private boolean areSwitchExpressionsSupported;

    public RecorderInstrEmitter(boolean isEnum) {
        this.isEnum = isEnum;
    }

    @Override
    public void init(InstrumentationState state) {
        this.recorderCfg = RecorderInstrEmitter.getConfigBits(state.getCfg());
        this.recorderPrefix = state.getRecorderPrefix();
        this.classInstrStrategy = state.getCfg().isClassInstrStrategy();
        this.reportInitErrors = state.getCfg().isReportInitErrors();
        this.initString = state.getCfg().getInitString();
        this.distributedConfig = state.getCfg().getDistributedConfigString();
        this.profiles = state.getCfg().getProfiles();
        this.registryVersion = state.getSession().getVersion();
        this.javaLangPrefix = state.getCfg().getJavaLangPrefix();
        this.areLambdasSupported = state.getCfg().getSourceLevel().supportsFeature(LanguageFeature.LAMBDA);
        this.areSwitchExpressionsSupported = state.getCfg().getSourceLevel().supportsFeature(LanguageFeature.SWITCH_EXPRESSIONS);
        this.testClass = state.isDetectTests();
        this.isSpockTestClass = state.isSpockTestClass();
        this.isParameterizedJUnitTestClass = state.isParameterizedJUnitTestClass();
        this.classNotFoundMsg = state.getCfg().getClassNotFoundMsg() != null ? state.getCfg().getClassNotFoundMsg() : DEFAULT_CLASSNOTFOUND_MSG;
        boolean bl = this.shouldEmitWarningMethod = !state.hasInstrumented();
        if (!state.hasInstrumented()) {
            state.setHasInstrumented(true);
        }
        this.stateView = new InstrumentationStateView(state);
    }

    @Override
    public String getInstr() {
        String instrString;
        if (this.classInstrStrategy || this.isEnum) {
            String recorderBase = this.recorderPrefix.substring(0, this.recorderPrefix.lastIndexOf(46));
            String recorderSuffix = this.recorderPrefix.substring(this.recorderPrefix.lastIndexOf(46) + 1);
            instrString = String.valueOf(this.testClass ? "" : "public ") + "static class " + recorderBase + "{";
            instrString = String.valueOf(instrString) + "public static " + CoverageRecorder.class.getName() + " " + recorderSuffix + ";";
            instrString = String.valueOf(instrString) + RecorderInstrEmitter.generateCloverProfilesField(this.profiles);
            if (this.areLambdasSupported) {
                instrString = String.valueOf(instrString) + this.generateLambdaIncMethod(recorderSuffix);
            }
            if (this.areSwitchExpressionsSupported) {
                instrString = String.valueOf(instrString) + this.generateCaseIncValueMethod(recorderSuffix);
                instrString = String.valueOf(instrString) + this.generateCaseIncVoidMethod(recorderSuffix);
            }
            instrString = String.valueOf(instrString) + "static{";
            instrString = String.valueOf(instrString) + CoverageRecorder.class.getName() + " _" + recorderSuffix + "=null;";
            if (this.reportInitErrors) {
                instrString = String.valueOf(instrString) + "try{" + (this.shouldEmitWarningMethod ? String.valueOf(Bindings.$CloverVersionInfo$oldVersionInClasspath()) + ";" : "") + "if(" + CloverVersionInfo.getBuildStamp() + "L!=" + Bindings.$CloverVersionInfo$getBuildStamp() + ")" + "{" + Bindings.$Clover$l("\"[CLOVER] WARNING: The Clover version used in instrumentation shall match the runtime version.\"") + ";" + Bindings.$Clover$l("\"[CLOVER] WARNING: Instr=" + CloverVersionInfo.getReleaseNum() + "#" + CloverVersionInfo.getBuildStamp() + ",Runtime=\"+" + Bindings.$CloverVersionInfo$getReleaseNum() + "+\"#\"+" + Bindings.$CloverVersionInfo$getBuildStamp()) + ";}";
            }
            instrString = String.valueOf(instrString) + recorderSuffix + "=" + Bindings.$Clover$getNullRecorder() + ";";
            instrString = String.valueOf(instrString) + "_" + recorderSuffix + "=" + Bindings.$Clover$getNullRecorder() + ";";
            instrString = String.valueOf(instrString) + "_" + recorderSuffix + "=" + Bindings.$Clover$getRecorder(RecorderInstrEmitter.asUnicodeString(this.initString), String.valueOf(this.registryVersion) + "L", String.valueOf(this.recorderCfg) + "L", Integer.toString(this.maxDataIndex), "profiles", "new " + this.javaLangPrefix + "String[]{\"" + "clover.distributed.coverage" + "\"," + RecorderInstrEmitter.asUnicodeString(this.distributedConfig) + "}") + ";";
            if (this.reportInitErrors) {
                instrString = String.valueOf(instrString) + "}catch(" + this.javaLangPrefix + "SecurityException e){" + this.javaLangPrefix + "System.err.println(\"" + "[CLOVER] FATAL ERROR: Clover could not be initialised because it has insufficient security privileges. Please consult the Clover documentation on the security policy file changes required." + " (\"+e.getClass()+\":\"+e.getMessage()+\")\");";
                instrString = String.valueOf(instrString) + "}catch(" + this.javaLangPrefix + "NoClassDefFoundError e){" + this.javaLangPrefix + "System.err.println(\"" + this.classNotFoundMsg + " (\"+e.getClass()+\":\"+e.getMessage()+\")\");";
                instrString = String.valueOf(instrString) + "}catch(" + this.javaLangPrefix + "Throwable t){" + this.javaLangPrefix + "System.err.println(\"" + UNEXPECTED_MSG + " (\"+t.getClass()+\":\"+t.getMessage()+\")\");}";
            }
            instrString = String.valueOf(instrString) + recorderSuffix + "=" + "_" + recorderSuffix + ";";
            instrString = String.valueOf(instrString) + "}}";
        } else {
            instrString = "public static " + CoverageRecorder.class.getName() + " " + this.recorderPrefix + "=" + Bindings.$Clover$getRecorder(RecorderInstrEmitter.asUnicodeString(this.initString), String.valueOf(this.registryVersion) + "L", String.valueOf(this.recorderCfg) + "L", Integer.toString(this.maxDataIndex), RecorderInstrEmitter.generateCloverProfilesInline(this.profiles), "new " + this.javaLangPrefix + "String[]{\"" + "clover.distributed.coverage" + "\"," + RecorderInstrEmitter.asUnicodeString(this.distributedConfig) + "}") + ";";
        }
        instrString = String.valueOf(instrString) + RecorderInstrEmitter.generateTestSnifferField(this.isSpockTestClass, this.isParameterizedJUnitTestClass, this.stateView.isJUnit5ParameterizedTest());
        return instrString;
    }

    static String generateTestSnifferField(boolean isSpock, boolean isParamJUnit, boolean isJunit5ParamTest) {
        return RecorderInstrEmitter.generateTestSnifferField(isSpock ? SnifferType.SPOCK : (isParamJUnit || isJunit5ParamTest ? SnifferType.JUNIT : SnifferType.NULL));
    }

    static String generateTestSnifferField(SnifferType snifferType) {
        String snifferField = "public static final " + TestNameSniffer.class.getName() + " " + "__CLR4_5_2_TEST_NAME_SNIFFER";
        switch (snifferType) {
            case JUNIT: 
            case SPOCK: {
                return String.valueOf(snifferField) + "=new com_atlassian_clover.TestNameSniffer.Simple();";
            }
        }
        return String.valueOf(snifferField) + "=" + TestNameSniffer.class.getName() + ".NULL_INSTANCE;";
    }

    private String generateLambdaIncMethod(String recorderSuffix) {
        StringBuilder str = new StringBuilder().append("@java.lang.SuppressWarnings(\"unchecked\") ").append("public static <I, T extends I> I ").append(LAMBDA_INC_METHOD).append("(final int i,final T l,final int si){").append("java.lang.reflect.InvocationHandler h=new java.lang.reflect.InvocationHandler(){").append("public ").append(this.javaLangPrefix).append("Object invoke(").append(this.javaLangPrefix).append("Object p,java.lang.reflect.Method m,").append(this.javaLangPrefix).append("Object[] a) ").append("throws Throwable{").append(recorderSuffix).append(".inc(i);").append(recorderSuffix).append(".inc(si);").append("try{return m.invoke(l,a);}catch(java.lang.reflect.InvocationTargetException e){").append("throw e.getCause()!=null?e.getCause():new RuntimeException(\"Clover failed to invoke instrumented lambda\",e);").append("}}};").append("return (I)java.lang.reflect.Proxy.newProxyInstance(l.getClass().getClassLoader(),l.getClass().getInterfaces(),h);").append("}");
        return str.toString();
    }

    private String generateCaseIncValueMethod(String recorderSuffix) {
        return "public static <T> T caseInc(int i,java.util.function.Supplier<T> s){" + recorderSuffix + ".inc(i);return s.get();}";
    }

    private String generateCaseIncVoidMethod(String recorderSuffix) {
        return "public static void caseInc(int i,Runnable r){" + recorderSuffix + ".inc(i);r.run();}";
    }

    static String generateCloverProfilesField(List<CloverProfile> profiles) {
        String str = "public static " + CloverProfile.class.getName() + "[] profiles = { ";
        str = String.valueOf(str) + RecorderInstrEmitter.generateCloverProfilesNewInstances(profiles);
        str = String.valueOf(str) + "};";
        return str;
    }

    public static String generateCloverProfilesInline(List<CloverProfile> profiles) {
        return "new " + CloverProfile.class.getName() + "[] {" + RecorderInstrEmitter.generateCloverProfilesNewInstances(profiles) + "}";
    }

    private static String generateCloverProfilesNewInstances(List<CloverProfile> profiles) {
        StringBuilder str = new StringBuilder();
        if (profiles != null) {
            Iterator<CloverProfile> iter = profiles.iterator();
            while (iter.hasNext()) {
                CloverProfile profile = iter.next();
                str.append("new ").append(CloverProfile.class.getName()).append("(");
                str.append(RecorderInstrEmitter.asUnicodeString(profile.getName())).append(", ");
                str.append("\"").append((Object)profile.getCoverageRecorder()).append("\", ");
                if (profile.getDistributedCoverage() != null) {
                    str.append(RecorderInstrEmitter.asUnicodeString(profile.getDistributedCoverage().getConfigString())).append(")");
                } else {
                    str.append("null)");
                }
                if (!iter.hasNext()) continue;
                str.append(",");
            }
        }
        return str.toString();
    }

    public static String asUnicodeString(String str) {
        if (str == null) {
            return "null";
        }
        StringBuilder res = new StringBuilder("\"");
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\\') {
                res.append(String.format(Locale.US, "\\u%04x\\u%04x", (int)c, (int)c));
            } else {
                res.append(String.format(Locale.US, "\\u%04x", (int)c));
            }
            ++n2;
        }
        res.append("\"");
        return res.toString();
    }

    public void setMaxDataIndex(int maxIndex) {
        this.maxDataIndex = maxIndex;
    }

    private static long getConfigBits(InstrumentationConfig cfg) {
        return CoverageRecorder.getConfigBits(cfg.getFlushPolicy(), cfg.getFlushInterval(), false, false, !cfg.isSliceRecording());
    }

    private static class InstrumentationStateView {
        private InstrumentationState state;

        private InstrumentationStateView(InstrumentationState state) {
            this.state = state;
        }

        private boolean isJUnit5ParameterizedTest() {
            return this.state.isParameterizedJUnit5TestClass();
        }
    }
}

