/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart;

import clover.org.jfree.chart.util.ParamChecks;
import clover.org.jfree.io.SerialUtilities;
import clover.org.jfree.util.PaintUtilities;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PaintMap
implements Cloneable,
Serializable {
    static final long serialVersionUID = -4639833772123069274L;
    private transient Map store = new HashMap();

    public Paint getPaint(Comparable key) {
        ParamChecks.nullNotPermitted(key, "key");
        return (Paint)this.store.get(key);
    }

    public boolean containsKey(Comparable key) {
        return this.store.containsKey(key);
    }

    public void put(Comparable key, Paint paint) {
        ParamChecks.nullNotPermitted(key, "key");
        this.store.put(key, paint);
    }

    public void clear() {
        this.store.clear();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaintMap)) {
            return false;
        }
        PaintMap that = (PaintMap)obj;
        if (this.store.size() != that.store.size()) {
            return false;
        }
        Set keys = this.store.keySet();
        for (Comparable key : keys) {
            Paint p2;
            Paint p1 = this.getPaint(key);
            if (PaintUtilities.equal(p1, p2 = that.getPaint(key))) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        PaintMap clone = (PaintMap)super.clone();
        clone.store = new HashMap();
        clone.store.putAll(this.store);
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.store.size());
        Set keys = this.store.keySet();
        for (Comparable key : keys) {
            stream.writeObject(key);
            Paint paint = this.getPaint(key);
            SerialUtilities.writePaint(paint, stream);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.store = new HashMap();
        int keyCount = stream.readInt();
        for (int i = 0; i < keyCount; ++i) {
            Comparable key = (Comparable)stream.readObject();
            Paint paint = SerialUtilities.readPaint(stream);
            this.store.put(key, paint);
        }
    }
}

