/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.testopt.settings;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.openclover.eclipse.testopt.TestOptimizationPlugin;
import org.openclover.eclipse.testopt.TestOptimizationPluginMessages;
import org.openclover.eclipse.testopt.settings.TestOptimizationPreferencesControl;

public class OptimizedLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private final IPreferenceStore preferenceStore = new PreferenceStore();
    private TestOptimizationPreferencesControl control;
    private Button useDefaultsButton;

    public String getName() {
        return "Test Optimization";
    }

    public Image getImage() {
        return TestOptimizationPlugin.getDefault().getTestOptimizationIcon();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Composite defaultsComposite = new Composite(container, 0);
        defaultsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        defaultsComposite.setLayout((Layout)new GridLayout(2, false));
        this.useDefaultsButton = new Button(defaultsComposite, 32);
        this.useDefaultsButton.setLayoutData((Object)new GridData(4, 2, true, false));
        this.useDefaultsButton.setText(TestOptimizationPluginMessages.getString("launch.optimized.prefs.usedefaults"));
        this.useDefaultsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OptimizedLaunchConfigurationTab.this.control.setEnabled(!OptimizedLaunchConfigurationTab.this.useDefaultsButton.getSelection());
                OptimizedLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button copyDefaults = new Button(defaultsComposite, 8);
        copyDefaults.setText(TestOptimizationPluginMessages.getString("launch.optimized.prefs.copydefaults"));
        copyDefaults.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                OptimizedLaunchConfigurationTab.this.control.loadDefaults();
            }
        });
        this.control = new TestOptimizationPreferencesControl(container, null, this.preferenceStore);
        this.control.setLayoutData(new GridData(4, 1, true, false));
        this.control.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("field_editor_is_valid".equals(event.getProperty())) {
                    if (Boolean.TRUE.equals(event.getNewValue())) {
                        OptimizedLaunchConfigurationTab.this.setErrorMessage(null);
                    } else {
                        StringFieldEditor fieldEditor = (StringFieldEditor)event.getSource();
                        OptimizedLaunchConfigurationTab.this.setErrorMessage(fieldEditor.getErrorMessage());
                    }
                }
                OptimizedLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.setControl((Control)container);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IPreferenceStore defaults = TestOptimizationPlugin.getDefault().getPreferenceStore();
        configuration.setAttribute("org.openclover.eclipse.testopt.USE_DEFAULT_SETTINGS", true);
        configuration.setAttribute("org.openclover.eclipse.testopt.SHOW_NO_TESTS_FOUND_DIALOG", defaults.getBoolean("org.openclover.eclipse.testopt.SHOW_NO_TESTS_FOUND_DIALOG"));
        configuration.setAttribute("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS", defaults.getBoolean("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS"));
        configuration.setAttribute("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS_AGE", defaults.getInt("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS_AGE"));
        configuration.setAttribute("org.openclover.eclipse.testopt.MINIMIZE_TESTS", defaults.getBoolean("org.openclover.eclipse.testopt.MINIMIZE_TESTS"));
        configuration.setAttribute("org.openclover.eclipse.testopt.TEST_REORDERING", defaults.getString("org.openclover.eclipse.testopt.TEST_REORDERING"));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        IPreferenceStore defaults = TestOptimizationPlugin.getDefault().getPreferenceStore();
        this.copyBooleanToPreferences(configuration, defaults, "org.openclover.eclipse.testopt.SHOW_NO_TESTS_FOUND_DIALOG");
        this.copyBooleanToPreferences(configuration, defaults, "org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS");
        this.copyIntToPreferences(configuration, defaults, "org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS_AGE");
        this.copyBooleanToPreferences(configuration, defaults, "org.openclover.eclipse.testopt.MINIMIZE_TESTS");
        this.copyStringToPreferences(configuration, defaults, "org.openclover.eclipse.testopt.TEST_REORDERING");
        this.control.load();
        try {
            boolean useDefaults = configuration.getAttribute("org.openclover.eclipse.testopt.USE_DEFAULT_SETTINGS", true);
            this.useDefaultsButton.setSelection(useDefaults);
            this.control.setEnabled(!useDefaults);
        }
        catch (CoreException e) {
            TestOptimizationPlugin.logWarning("Problem retrieving launch configuration attribute", e);
        }
    }

    public boolean canSave() {
        return this.control.isValid();
    }

    private void copyBooleanToPreferences(ILaunchConfiguration config, IPreferenceStore defaults, String attribute) {
        try {
            boolean def = defaults.getBoolean(attribute);
            this.preferenceStore.setDefault(attribute, def);
            this.preferenceStore.setValue(attribute, config.getAttribute(attribute, def));
        }
        catch (CoreException e) {
            TestOptimizationPlugin.logWarning("Problem retrieving launch configuration attribute " + attribute, e);
        }
    }

    private void copyIntToPreferences(ILaunchConfiguration config, IPreferenceStore defaults, String attribute) {
        try {
            int def = defaults.getInt(attribute);
            this.preferenceStore.setDefault(attribute, def);
            this.preferenceStore.setValue(attribute, config.getAttribute(attribute, def));
        }
        catch (CoreException e) {
            TestOptimizationPlugin.logWarning("Problem retrieving launch configuration attribute " + attribute, e);
        }
    }

    private void copyStringToPreferences(ILaunchConfiguration config, IPreferenceStore defaults, String attribute) {
        try {
            String def = defaults.getString(attribute);
            this.preferenceStore.setDefault(attribute, def);
            this.preferenceStore.setValue(attribute, config.getAttribute(attribute, def));
        }
        catch (CoreException e) {
            TestOptimizationPlugin.logWarning("Problem retrieving launch configuration attribute " + attribute, e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.control.store();
        configuration.setAttribute("org.openclover.eclipse.testopt.USE_DEFAULT_SETTINGS", this.useDefaultsButton.getSelection());
        configuration.setAttribute("org.openclover.eclipse.testopt.SHOW_NO_TESTS_FOUND_DIALOG", this.preferenceStore.getBoolean("org.openclover.eclipse.testopt.SHOW_NO_TESTS_FOUND_DIALOG"));
        configuration.setAttribute("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS", this.preferenceStore.getBoolean("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS"));
        configuration.setAttribute("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS_AGE", this.preferenceStore.getInt("org.openclover.eclipse.testopt.DISCARD_STALE_SNAPSHOTS_AGE"));
        configuration.setAttribute("org.openclover.eclipse.testopt.MINIMIZE_TESTS", this.preferenceStore.getBoolean("org.openclover.eclipse.testopt.MINIMIZE_TESTS"));
        configuration.setAttribute("org.openclover.eclipse.testopt.TEST_REORDERING", this.preferenceStore.getString("org.openclover.eclipse.testopt.TEST_REORDERING"));
    }
}

