/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.widgets.columns;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.reporters.ExpressionEvaluator;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.openclover.eclipse.core.ui.SwtUtils;
import org.openclover.eclipse.core.views.BuiltinMetricsColumnDefinition;
import org.openclover.eclipse.core.views.BuiltinPcMetricsColumnDefinition;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.CustomColumnDefinition;

public class CustomColumnDialog
extends TitleAreaDialog {
    private Button validateButton;
    private Text expressionText;
    private Text nameText;
    private CustomColumnDefinition columnDef;
    private Combo formatCombo;
    private Combo alignmentCombo;
    private Button addColumnButton;
    private Set<? extends ColumnDefinition> builtintColumns;

    public CustomColumnDialog(Shell shell, Set<? extends ColumnDefinition> builtintColumns, CustomColumnDefinition customColumnDefinition) {
        this(shell, builtintColumns);
        this.columnDef = customColumnDefinition;
    }

    public CustomColumnDialog(Shell shell, Set<? extends ColumnDefinition> builtintColumns) {
        super(shell);
        this.setShellStyle(68720);
        this.builtintColumns = builtintColumns;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Custom Column Builder");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Define a custom column using the Clover expression language");
        this.setMessage("Enter the column name, alignment, format and expression.");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        SwtUtils.gridDataFor((Control)separator).horizontalSpan = 3;
        Label nameLabel = new Label(composite, 0);
        nameLabel.setLayoutData((Object)new GridData(768));
        SwtUtils.gridDataFor((Control)nameLabel).horizontalSpan = 3;
        nameLabel.setText("Name:");
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(this.columnDef == null ? "" : this.columnDef.getTitle());
        SwtUtils.gridDataFor((Control)this.nameText).horizontalSpan = 2;
        new Label(composite, 0);
        Label alignmentLabel = new Label(composite, 0);
        alignmentLabel.setLayoutData((Object)new GridData(768));
        alignmentLabel.setText("Aligment:");
        Label formatLabel = new Label(composite, 0);
        formatLabel.setLayoutData((Object)new GridData(768));
        formatLabel.setText("Format:");
        new Label(composite, 0);
        this.alignmentCombo = new Combo(composite, 8);
        this.alignmentCombo.add("Left");
        this.alignmentCombo.add("Center");
        this.alignmentCombo.add("Right");
        this.alignmentCombo.select(this.columnDef == null ? 0 : (this.columnDef.getAlignment() == 16384 ? 0 : (this.columnDef.getAlignment() == 0x1000000 ? 1 : 2)));
        this.formatCombo = new Combo(composite, 8);
        this.formatCombo.add("Raw value");
        this.formatCombo.add("Percentage");
        this.formatCombo.select(this.columnDef == null ? 0 : (this.columnDef.getFormat() == 0 ? 0 : 1));
        new Label(composite, 0);
        Label expressionLabel = new Label(composite, 0);
        expressionLabel.setLayoutData((Object)new GridData(768));
        SwtUtils.gridDataFor((Control)expressionLabel).horizontalSpan = 2;
        expressionLabel.setText("Expression:");
        this.expressionText = new Text(composite, 2050);
        this.expressionText.setLayoutData((Object)new GridData(1808));
        SwtUtils.gridDataFor((Control)this.expressionText).horizontalSpan = 2;
        SwtUtils.gridDataFor((Control)this.expressionText).verticalSpan = 2;
        this.expressionText.setFont(new Font(null, "Courier", 14, 0));
        this.expressionText.setText(this.columnDef == null ? "" : this.columnDef.getExpression());
        SwtUtils.gridDataFor((Control)this.expressionText).heightHint = 300;
        SwtUtils.gridDataFor((Control)this.expressionText).widthHint = 350;
        this.validateButton = new Button(composite, 0);
        this.validateButton.setLayoutData((Object)new GridData(2));
        this.validateButton.setText("Validate");
        this.validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    ExpressionEvaluator.validate(CustomColumnDialog.this.expressionText.getText(), CustomColumnDialog.this.nameText.getText());
                    CustomColumnDialog.this.setMessage("Expression is valid.", 1);
                }
                catch (CloverException e) {
                    CustomColumnDialog.this.setMessage("Expression is invalid: " + e.getMessage(), 3);
                }
            }
        });
        this.addColumnButton = new Button(composite, 12);
        this.addColumnButton.setLayoutData((Object)new GridData(2));
        this.addColumnButton.setText("Insert...");
        MenuManager menuManager = new MenuManager();
        final Menu menu = menuManager.createContextMenu((Control)this.addColumnButton);
        for (ColumnDefinition columnDefinition : this.builtintColumns) {
            if (!(columnDefinition instanceof BuiltinMetricsColumnDefinition)) continue;
            final BuiltinMetricsColumnDefinition metricsColDef = (BuiltinMetricsColumnDefinition)columnDefinition;
            menuManager.add((IAction)new Action(columnDefinition.getTitle() + "\t(" + metricsColDef.getPrototype().getName() + ")"){

                public void run() {
                    int caretPos = CustomColumnDialog.this.expressionText.getCaretPosition();
                    String charBefore = CustomColumnDialog.this.expressionText.getText(caretPos - 1, caretPos);
                    String charAfter = CustomColumnDialog.this.expressionText.getText(caretPos, caretPos + 1);
                    CustomColumnDialog.this.expressionText.insert((charBefore.trim().length() == 0 ? "" : " ") + (metricsColDef instanceof BuiltinPcMetricsColumnDefinition ? "%" : "") + metricsColDef.getPrototype().getName() + (charAfter.trim().length() == 0 ? "" : " "));
                }
            });
        }
        this.addColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Point buttonLocation = CustomColumnDialog.this.addColumnButton.getParent().toDisplay(CustomColumnDialog.this.addColumnButton.getLocation());
                Rectangle buttonBounds = CustomColumnDialog.this.addColumnButton.getBounds();
                menu.setLocation(buttonLocation.x, buttonLocation.y + buttonBounds.height);
                menu.setVisible(true);
            }
        });
        return composite;
    }

    protected void okPressed() {
        if (this.nameText.getText().trim().length() == 0) {
            this.setMessage("The column title must be non-blank.", 3);
            return;
        }
        if (this.expressionText.getText().trim().length() == 0) {
            this.setMessage("The column expression must be non-blank.", 3);
            return;
        }
        try {
            int format;
            int alignmentSelection = this.alignmentCombo.getSelectionIndex();
            int alignment = alignmentSelection == 0 ? 16384 : (alignmentSelection == 1 ? 0x1000000 : 131072);
            int formatSeletion = this.formatCombo.getSelectionIndex();
            int n = format = formatSeletion == 0 ? 0 : 1;
            this.columnDef = this.columnDef == null ? new CustomColumnDefinition(this.nameText.getText(), this.nameText.getText(), this.expressionText.getText(), alignment, format) : new CustomColumnDefinition(this.columnDef.getId(), this.nameText.getText(), this.nameText.getText(), this.expressionText.getText(), alignment, format);
        }
        catch (CloverException e) {
            this.setMessage("The column expression contains errors: " + e.getMessage(), 3);
            return;
        }
        super.okPressed();
    }

    public boolean close() {
        return super.close();
    }

    public CustomColumnDefinition getColumn() {
        return this.columnDef;
    }
}

