/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.widgets.columns;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.openclover.eclipse.core.ui.SwtUtils;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.CustomColumnDefinition;
import org.openclover.eclipse.core.views.widgets.columns.ColumnDefinitionLabelProvider;
import org.openclover.eclipse.core.views.widgets.columns.ColumnDefinitionsModel;
import org.openclover.eclipse.core.views.widgets.columns.ColumnDefinitionsProvider;
import org.openclover.eclipse.core.views.widgets.columns.CustomColumnDialog;

public class ColumnSelectionDialog
extends Dialog {
    private static final int IMPORT_ID = 1025;
    private static final int EXPORT_ID = 1026;
    private static final int BUTTON_WIDTH_HINT = 80;
    private static final int TABLE_WIDTH_HINT = 200;
    private static final int TABLE_RHS_HEIGHT_HINT = 300;
    private static final int TABLE_LHS_HEIGHT_HINT = 200;
    private ColumnDefinitionsModel model;
    private String viewName;
    private Table selectedColumnsTable;
    private TableViewer selectedColumnsTableViewer;
    private Table allBuiltinColumnsTable;
    private TableViewer allBuiltinColumnsTableViewer;
    private Table allCustomColumnsTable;
    private TableViewer allCustomColumnsTableViewer;
    private Button upButton;
    private Button allLeftButton;
    private Button downButton;
    private Button leftButton;
    private Button removeCustomUnassignedButton;
    private Button editCustomUnassignedButton;
    private Button newCustomButton;
    private Button customAllRightButton;
    private Button customRightButton;
    private Button builtinAllRightButton;
    private Button builtinRightButton;
    private Button editCustomAssignedButton;

    public ColumnSelectionDialog(Shell parentShell, String viewName, ColumnDefinition[] selectedColumns, ColumnDefinition[] allColumns) {
        super(parentShell);
        this.viewName = viewName;
        this.model = new ColumnDefinitionsModel(selectedColumns, allColumns);
        this.setShellStyle(68720);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.viewName + " Column Chooser");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 1025) {
            this.doImport();
        } else if (buttonId == 1026) {
            this.doExport();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        Composite availableColumns = new Composite(composite, 0);
        availableColumns.setLayout((Layout)new GridLayout(2, false));
        availableColumns.setLayoutData((Object)new GridData(1808));
        new Label(availableColumns, 0).setText("Available built-in columns:");
        new Label(availableColumns, 0);
        this.allBuiltinColumnsTable = new Table(availableColumns, 2048);
        this.allBuiltinColumnsTable.setLayoutData((Object)new GridData(1808));
        SwtUtils.gridDataFor((Control)this.allBuiltinColumnsTable).verticalSpan = 2;
        SwtUtils.gridDataFor((Control)this.allBuiltinColumnsTable).heightHint = 200;
        SwtUtils.gridDataFor((Control)this.allBuiltinColumnsTable).widthHint = 200;
        this.allBuiltinColumnsTableViewer = new TableViewer(this.allBuiltinColumnsTable);
        this.allBuiltinColumnsTableViewer.setLabelProvider((IBaseLabelProvider)new ColumnDefinitionLabelProvider());
        this.allBuiltinColumnsTableViewer.setContentProvider((IContentProvider)new ColumnDefinitionsProvider(){

            @Override
            public Object[] getElements(Object root) {
                Object[] columns = ColumnSelectionDialog.this.model.getRemainingBuiltins().toArray();
                Arrays.sort(columns, ColumnDefinition.TITLE_COMPARATOR);
                return columns;
            }
        });
        this.allBuiltinColumnsTableViewer.setInput((Object)this.model);
        this.allBuiltinColumnsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnSelectionDialog.this.updateButtonStates();
            }
        });
        this.builtinRightButton = new Button(availableColumns, 0);
        this.builtinRightButton.setLayoutData((Object)new GridData(258));
        SwtUtils.gridDataFor((Control)this.builtinRightButton).widthHint = 80;
        this.builtinRightButton.setText(">");
        this.builtinRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColumnSelectionDialog.this.model.assign((ColumnDefinition)ColumnSelectionDialog.this.allBuiltinColumnsTable.getSelection()[0].getData());
            }
        });
        this.builtinRightButton.setEnabled(false);
        this.builtinAllRightButton = new Button(availableColumns, 0);
        this.builtinAllRightButton.setLayoutData((Object)new GridData(258));
        SwtUtils.gridDataFor((Control)this.builtinAllRightButton).widthHint = 80;
        this.builtinAllRightButton.setText(">>");
        this.builtinAllRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColumnSelectionDialog.this.model.assignAll(false);
            }
        });
        new Label(availableColumns, 0).setText("Available custom columns:");
        new Label(availableColumns, 0);
        this.allCustomColumnsTable = new Table(availableColumns, 2048);
        this.allCustomColumnsTable.setLayoutData((Object)new GridData(1808));
        SwtUtils.gridDataFor((Control)this.allCustomColumnsTable).verticalSpan = 5;
        SwtUtils.gridDataFor((Control)this.allCustomColumnsTable).heightHint = 200;
        SwtUtils.gridDataFor((Control)this.allCustomColumnsTable).widthHint = 200;
        this.allCustomColumnsTableViewer = new TableViewer(this.allCustomColumnsTable);
        this.allCustomColumnsTableViewer.setLabelProvider((IBaseLabelProvider)new ColumnDefinitionLabelProvider());
        this.allCustomColumnsTableViewer.setContentProvider((IContentProvider)new ColumnDefinitionsProvider(){

            @Override
            public Object[] getElements(Object root) {
                Object[] columns = ColumnSelectionDialog.this.model.getRemainingCustoms().toArray();
                Arrays.sort(columns, ColumnDefinition.TITLE_COMPARATOR);
                return columns;
            }
        });
        this.allCustomColumnsTableViewer.setInput((Object)this.model);
        this.allCustomColumnsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnSelectionDialog.this.updateButtonStates();
            }
        });
        this.customRightButton = new Button(availableColumns, 0);
        this.customRightButton.setLayoutData((Object)new GridData(264));
        SwtUtils.gridDataFor((Control)this.customRightButton).widthHint = 80;
        this.customRightButton.setText(">");
        this.customRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColumnSelectionDialog.this.model.assign((ColumnDefinition)ColumnSelectionDialog.this.allCustomColumnsTable.getSelection()[0].getData());
            }
        });
        this.customRightButton.setEnabled(false);
        this.customAllRightButton = new Button(availableColumns, 0);
        this.customAllRightButton.setLayoutData((Object)new GridData(258));
        SwtUtils.gridDataFor((Control)this.customAllRightButton).widthHint = 80;
        this.customAllRightButton.setText(">>");
        this.customAllRightButton.setEnabled(false);
        this.customAllRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColumnSelectionDialog.this.model.assignAll(true);
            }
        });
        this.newCustomButton = new Button(availableColumns, 0);
        this.newCustomButton.setLayoutData((Object)new GridData(258));
        SwtUtils.gridDataFor((Control)this.newCustomButton).widthHint = 80;
        this.newCustomButton.setText("New");
        this.newCustomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CustomColumnDialog dialog = new CustomColumnDialog(ColumnSelectionDialog.this.getShell(), ColumnSelectionDialog.this.model.getBuiltintColumns());
                if (dialog.open() == 0) {
                    ColumnSelectionDialog.this.model.addCustomColumn(dialog.getColumn());
                }
            }
        });
        this.editCustomUnassignedButton = new Button(availableColumns, 0);
        this.editCustomUnassignedButton.setLayoutData((Object)new GridData(258));
        SwtUtils.gridDataFor((Control)this.editCustomUnassignedButton).widthHint = 80;
        this.editCustomUnassignedButton.setText("Edit");
        this.editCustomUnassignedButton.setEnabled(false);
        this.editCustomUnassignedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CustomColumnDefinition originalDefinition = (CustomColumnDefinition)ColumnSelectionDialog.this.allCustomColumnsTable.getSelection()[0].getData();
                CustomColumnDialog dialog = new CustomColumnDialog(ColumnSelectionDialog.this.getShell(), ColumnSelectionDialog.this.model.getBuiltintColumns(), originalDefinition);
                if (dialog.open() == 0) {
                    ColumnSelectionDialog.this.model.replaceCustomColumn(originalDefinition, dialog.getColumn());
                }
            }
        });
        this.removeCustomUnassignedButton = new Button(availableColumns, 0);
        this.removeCustomUnassignedButton.setLayoutData((Object)new GridData(258));
        SwtUtils.gridDataFor((Control)this.removeCustomUnassignedButton).widthHint = 80;
        this.removeCustomUnassignedButton.setText("Delete");
        this.removeCustomUnassignedButton.setEnabled(false);
        this.removeCustomUnassignedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MessageDialog.openConfirm((Shell)ColumnSelectionDialog.this.getShell(), (String)"Delete Custom Column", (String)"Are you sure you wish to delete the custom column? It will be removed from any Clover views currently displaying it.")) {
                    ColumnSelectionDialog.this.model.removeCustomColumn((CustomColumnDefinition)ColumnSelectionDialog.this.allCustomColumnsTable.getSelection()[0].getData());
                }
            }
        });
        Label separator = new Label(composite, 514);
        separator.setLayoutData((Object)new GridData(1040));
        Composite assignedColumns = new Composite(composite, 0);
        assignedColumns.setLayout((Layout)new GridLayout(3, false));
        assignedColumns.setLayoutData((Object)new GridData(1808));
        new Label(assignedColumns, 0);
        Label assignedLabel = new Label(assignedColumns, 0);
        assignedLabel.setText("Assigned columns:");
        SwtUtils.gridDataFor((Control)assignedLabel).horizontalSpan = 2;
        this.leftButton = new Button(assignedColumns, 0);
        this.leftButton.setLayoutData((Object)new GridData(258));
        SwtUtils.gridDataFor((Control)this.leftButton).widthHint = 80;
        this.leftButton.setText("<");
        this.leftButton.setEnabled(false);
        this.leftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColumnSelectionDialog.this.model.deassign((ColumnDefinition)ColumnSelectionDialog.this.selectedColumnsTable.getItem(ColumnSelectionDialog.this.selectedColumnsTable.getSelectionIndex()).getData());
            }
        });
        this.selectedColumnsTable = new Table(assignedColumns, 2048);
        this.selectedColumnsTable.setLayoutData((Object)new GridData(1808));
        SwtUtils.gridDataFor((Control)this.selectedColumnsTable).verticalSpan = 3;
        SwtUtils.gridDataFor((Control)this.selectedColumnsTable).heightHint = 300;
        SwtUtils.gridDataFor((Control)this.selectedColumnsTable).widthHint = 200;
        this.selectedColumnsTableViewer = new TableViewer(this.selectedColumnsTable);
        this.selectedColumnsTableViewer.setLabelProvider((IBaseLabelProvider)new ColumnDefinitionLabelProvider());
        this.selectedColumnsTableViewer.setContentProvider((IContentProvider)new ColumnDefinitionsProvider(){

            @Override
            public Object[] getElements(Object root) {
                return ColumnSelectionDialog.this.model.getAssigned().toArray();
            }
        });
        this.selectedColumnsTableViewer.setInput((Object)this.model);
        this.selectedColumnsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnSelectionDialog.this.updateButtonStates();
            }
        });
        this.upButton = new Button(assignedColumns, 0);
        this.upButton.setLayoutData((Object)new GridData(258));
        SwtUtils.gridDataFor((Control)this.upButton).widthHint = 80;
        this.upButton.setText("Up");
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColumnSelectionDialog.this.model.moveAssignedUp((ColumnDefinition)ColumnSelectionDialog.this.selectedColumnsTable.getSelection()[0].getData());
            }
        });
        this.allLeftButton = new Button(assignedColumns, 0);
        this.allLeftButton.setLayoutData((Object)new GridData(258));
        SwtUtils.gridDataFor((Control)this.allLeftButton).widthHint = 80;
        this.allLeftButton.setText("<<");
        this.allLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColumnSelectionDialog.this.model.deassignAll();
            }
        });
        this.downButton = new Button(assignedColumns, 0);
        this.downButton.setLayoutData((Object)new GridData(258));
        SwtUtils.gridDataFor((Control)this.downButton).widthHint = 80;
        this.downButton.setText("Down");
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColumnSelectionDialog.this.model.moveAssignedDown((ColumnDefinition)ColumnSelectionDialog.this.selectedColumnsTable.getSelection()[0].getData());
            }
        });
        new Label(assignedColumns, 0);
        this.editCustomAssignedButton = new Button(assignedColumns, 0);
        this.editCustomAssignedButton.setLayoutData((Object)new GridData(258));
        SwtUtils.gridDataFor((Control)this.editCustomAssignedButton).widthHint = 80;
        this.editCustomAssignedButton.setText("Edit");
        this.editCustomAssignedButton.setEnabled(false);
        this.editCustomAssignedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CustomColumnDefinition originalDefinition = (CustomColumnDefinition)ColumnSelectionDialog.this.selectedColumnsTable.getSelection()[0].getData();
                CustomColumnDialog dialog = new CustomColumnDialog(ColumnSelectionDialog.this.getShell(), ColumnSelectionDialog.this.model.getBuiltintColumns(), originalDefinition);
                if (dialog.open() == 0) {
                    ColumnSelectionDialog.this.model.replaceCustomColumn(originalDefinition, dialog.getColumn());
                }
            }
        });
        this.model.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ColumnSelectionDialog.this.selectedColumnsTableViewer.refresh();
                ColumnSelectionDialog.this.allBuiltinColumnsTableViewer.refresh();
                ColumnSelectionDialog.this.allCustomColumnsTableViewer.refresh();
                ColumnSelectionDialog.this.updateButtonStates();
            }
        });
        return composite;
    }

    public Set getCustomColumns() {
        return this.model.getCustomColumns();
    }

    public List getVisibleColumns() {
        return this.model.getAssigned();
    }

    private void doImport() {
    }

    private void doExport() {
    }

    private void updateButtonStates() {
        this.builtinRightButton.setEnabled(this.allBuiltinColumnsTable.getSelectionIndex() != -1);
        this.builtinAllRightButton.setEnabled(this.allBuiltinColumnsTable.getItemCount() > 0);
        this.customRightButton.setEnabled(this.allCustomColumnsTable.getSelectionIndex() != -1);
        this.customAllRightButton.setEnabled(this.allCustomColumnsTable.getItemCount() > 0);
        this.editCustomUnassignedButton.setEnabled(this.allCustomColumnsTable.getSelectionIndex() != -1);
        this.removeCustomUnassignedButton.setEnabled(this.allCustomColumnsTable.getSelectionIndex() != -1);
        this.leftButton.setEnabled(this.selectedColumnsTable.getSelectionIndex() != -1 && !((ColumnDefinition)this.selectedColumnsTable.getItem(this.selectedColumnsTable.getSelectionIndex()).getData()).isLocked());
        this.allLeftButton.setEnabled(this.selectedColumnsTable.getItemCount() > 0);
        this.upButton.setEnabled(this.selectedColumnsTable.getSelectionIndex() > 0 && !((ColumnDefinition)this.selectedColumnsTable.getItem(this.selectedColumnsTable.getSelectionIndex()).getData()).isLocked() && !((ColumnDefinition)this.selectedColumnsTable.getItem(this.selectedColumnsTable.getSelectionIndex() - 1).getData()).isLocked());
        this.downButton.setEnabled(this.selectedColumnsTable.getSelectionIndex() >= 0 && this.selectedColumnsTable.getSelectionIndex() < this.selectedColumnsTable.getItemCount() - 1 && !((ColumnDefinition)this.selectedColumnsTable.getItem(this.selectedColumnsTable.getSelectionIndex()).getData()).isLocked() && !((ColumnDefinition)this.selectedColumnsTable.getItem(this.selectedColumnsTable.getSelectionIndex() + 1).getData()).isLocked());
        this.editCustomAssignedButton.setEnabled(this.selectedColumnsTable.getSelectionIndex() != -1 && ((ColumnDefinition)this.selectedColumnsTable.getItem(this.selectedColumnsTable.getSelectionIndex()).getData()).isCustom());
    }

    private ColumnDefinition getSelectedDefinition(SelectionChangedEvent event) {
        IStructuredSelection selection = event.getSelection() instanceof IStructuredSelection ? (IStructuredSelection)event.getSelection() : null;
        ColumnDefinition definition = selection == null ? null : (ColumnDefinition)selection.getFirstElement();
        return definition;
    }
}

