/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.widgets.columns;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.services.IDisposable;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.ui.CloverPluginIcons;
import org.openclover.eclipse.core.views.ColumnDefinition;

public class ColumnDefinitionLabelProvider
implements ITableLabelProvider,
IDisposable {
    private ResourceManager imageManager = new LocalResourceManager(JFaceResources.getResources());
    private Image customColumnImage;
    private Image builtinColumnImage;
    private Image builtinLockedColumnImage;
    private Image lockedColumnOverlayImage;
    private Image builtinColumnOverlayImage;

    public ColumnDefinitionLabelProvider() {
        try {
            this.customColumnImage = CloverPluginIcons.grabPluginImage(this.imageManager, "org.eclipse.ui.views", "icons/full/eview16/prop_ps.gif");
            if (this.customColumnImage == null) {
                CloverPlugin.logWarning("Unable to find column icon");
            }
        }
        catch (Exception e) {
            CloverPlugin.logError("Error loading column icon", e);
        }
        if (this.customColumnImage != null) {
            try {
                this.builtinColumnOverlayImage = CloverPlugin.getImage("icons/ovr16/clovered.gif");
                if (this.builtinColumnOverlayImage == null) {
                    CloverPlugin.logWarning("Unable to find builtin overlay icon");
                } else {
                    this.builtinColumnImage = this.imageManager.createImage((ImageDescriptor)new CompositeImageDescriptor(){

                        protected void drawCompositeImage(int width, int height) {
                            this.drawImage(ColumnDefinitionLabelProvider.this.customColumnImage.getImageData(), 0, 0);
                            this.drawImage(ColumnDefinitionLabelProvider.this.builtinColumnOverlayImage.getImageData(), 0, 0);
                        }

                        protected Point getSize() {
                            return new Point(((ColumnDefinitionLabelProvider)ColumnDefinitionLabelProvider.this).customColumnImage.getBounds().width, ((ColumnDefinitionLabelProvider)ColumnDefinitionLabelProvider.this).customColumnImage.getBounds().height);
                        }
                    });
                }
            }
            catch (Exception e) {
                CloverPlugin.logError("Error loading builtin column icon", e);
            }
            try {
                this.lockedColumnOverlayImage = CloverPlugin.getImage("icons/ovr16/locked.gif");
                if (this.builtinColumnOverlayImage != null && this.lockedColumnOverlayImage != null) {
                    this.builtinLockedColumnImage = this.imageManager.createImage((ImageDescriptor)new CompositeImageDescriptor(){

                        protected void drawCompositeImage(int width, int height) {
                            this.drawImage(ColumnDefinitionLabelProvider.this.customColumnImage.getImageData(), 0, 0);
                            this.drawImage(ColumnDefinitionLabelProvider.this.builtinColumnOverlayImage.getImageData(), 0, 0);
                            this.drawImage(ColumnDefinitionLabelProvider.this.lockedColumnOverlayImage.getImageData(), 0, 0);
                        }

                        protected Point getSize() {
                            return new Point(((ColumnDefinitionLabelProvider)ColumnDefinitionLabelProvider.this).customColumnImage.getBounds().width, ((ColumnDefinitionLabelProvider)ColumnDefinitionLabelProvider.this).customColumnImage.getBounds().height);
                        }
                    });
                }
            }
            catch (Exception e) {
                CloverPlugin.logError("Error loading locked & builtin column icon", e);
            }
        }
    }

    public String getColumnText(Object object, int col) {
        return ((ColumnDefinition)object).getTitle();
    }

    public Image getColumnImage(Object object, int col) {
        ColumnDefinition columnDef = (ColumnDefinition)object;
        if (columnDef.isCustom()) {
            return this.customColumnImage;
        }
        if (columnDef.isLocked()) {
            return this.builtinLockedColumnImage;
        }
        return this.builtinColumnImage;
    }

    public void dispose() {
        this.imageManager.dispose();
    }

    public boolean isLabelProperty(Object object, String name) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

