/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.openclover.eclipse.core.ui.SwtUtils;
import org.openclover.eclipse.core.views.ColumnCollectionSettings;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.widgets.BaseListeningRenderer;

public abstract class SelectionAwareCellRenderer
extends BaseListeningRenderer {
    public SelectionAwareCellRenderer(ColumnCollectionSettings columnSettings, ColumnDefinition column, Composite rendered) {
        super(rendered, columnSettings, column);
    }

    protected void renderText(String text, GC gc, Event event, Display display, int alignment) {
        this.drawText(text, gc, display, event, this.calcTargetColumnCurrentWidth(event), alignment);
    }

    @Override
    protected void paint(Event event) {
    }

    @Override
    protected void erase(Event event) {
        this.captureDetailsEvent(event);
        if (this.forThisColumn(event)) {
            if ((event.detail & 2) != 0 || this.forSelection(event)) {
                SwtUtils.renderSelectionBackground(event);
                event.detail &= 0xFFFFFFFD;
                event.detail &= 0xFFFFFFDF;
            }
            event.detail &= 0xFFFFFFF7;
        }
    }

    protected void captureDetailsEvent(Event event) {
        this.lastRowHeight = event.height;
        this.lastRowX = event.x;
        this.lastRowY = event.y;
    }

    protected void drawText(String text, GC gc, Display display, Event event, int columnWidth, int alignment, Color foreground) {
        SwtUtils.drawText(text, gc, foreground, this.lastRowX, this.lastRowY, columnWidth, this.lastRowHeight, 4, alignment);
    }

    protected void drawText(String text, GC gc, Display display, Event event, int columnWidth, int alignment) {
        Color foreground = (event.detail & 2) != 0 || this.forSelection(event) ? display.getSystemColor(27) : display.getSystemColor(24);
        this.drawText(text, gc, display, event, columnWidth, alignment, foreground);
    }
}

