/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.widgets;

import com.atlassian.clover.util.MetricsFormatUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import org.openclover.eclipse.core.views.ColumnCollectionSettings;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.widgets.SelectionAwareCellRenderer;

public abstract class HistogramCellRenderer
extends SelectionAwareCellRenderer {
    protected static final int MIN_BAR_WIDTH = 20;
    protected static final int PREFERRED_BAR_WIDTH = 35;

    public HistogramCellRenderer(Composite rendered, ColumnCollectionSettings columnSettings, ColumnDefinition column) {
        super(columnSettings, column, rendered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paint(Event event) {
        if (this.forThisColumn(event)) {
            Widget item = event.item;
            GC gc = event.gc;
            Display display = this.rendered.getDisplay();
            Color foreground = gc.getForeground();
            Color background = gc.getBackground();
            try {
                double percentage = this.percentValueFor(item == null ? null : item.getData());
                String text = this.percentLabelFor(item == null ? null : item.getData());
                if (this.barCanFitNextToLargestLabel(gc, event)) {
                    if (percentage != this.getEmptyValue()) {
                        this.renderBarAndText(text, this.sanitizePercentage(percentage), gc, event, display);
                    } else {
                        this.renderEmptyBarAndText(text, gc, event, display);
                    }
                } else {
                    this.renderText(text, gc, event, display, 131072);
                }
            }
            finally {
                gc.setForeground(background);
                gc.setBackground(foreground);
            }
        }
    }

    private boolean barCanFitNextToLargestLabel(GC gc, Event event) {
        int histogramWidth;
        int textWidth;
        int width = this.calcTargetColumnCurrentWidth(event);
        return width - (12 + (textWidth = gc.textExtent((String)this.getLargestExampleLabel()).x) + (histogramWidth = this.calculateBarWidth(gc, width))) >= 0;
    }

    private double sanitizePercentage(double percentage) {
        return Math.max(0.0, Math.min(1.0, percentage));
    }

    protected abstract double getEmptyValue();

    protected abstract String percentLabelFor(Object var1);

    protected abstract double percentValueFor(Object var1);

    protected String getLargestExampleLabel() {
        return MetricsFormatUtils.format100PcCoverage();
    }

    protected int calculateBarWidth(GC gc, int width) {
        Point maxTextSize = gc.textExtent(this.getLargestExampleLabel());
        return Math.max(width - maxTextSize.x - 12, 20);
    }

    protected int calculateBarHeight(int height) {
        return height - 8;
    }

    public static int getDefaultWidth() {
        return 175;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderBarAndText(String text, double percent, GC gc, Event event, Display display) {
        int columnWidth = this.calcTargetColumnCurrentWidth(event);
        int barWidth = this.calculateBarWidth(gc, columnWidth);
        int barHeight = this.calculateBarHeight(this.lastRowHeight);
        Color fullBarColour = this.allocateFullBarColour(display);
        try {
            Color emptyBarColour = this.allocateEmptyBarColour(display);
            try {
                gc.setBackground(fullBarColour);
                int width = (int)((double)barWidth * percent);
                gc.fillRectangle(this.lastRowX + 4, this.lastRowY + 4, width, barHeight);
                gc.setBackground(emptyBarColour);
                int uwidth = barWidth - width;
                gc.fillRectangle(this.lastRowX + 4 + width, this.lastRowY + 4, uwidth, barHeight);
                this.drawBarOutline(gc, display, barWidth, barHeight);
                if (text != null && text.trim().length() > 0) {
                    this.drawText(text, gc, display, event, columnWidth, 131072);
                }
            }
            finally {
                this.disposeEmptyBarColour(emptyBarColour);
            }
        }
        finally {
            this.disposeFullBarColour(fullBarColour);
        }
    }

    private void drawBarOutline(GC gc, Display display, int barWidth, int barHeight) {
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(this.lastRowX + 4, this.lastRowY + 4, barWidth, barHeight);
    }

    protected void renderEmptyBarAndText(String text, GC gc, Event event, Display display) {
        int columnWidth = this.calcTargetColumnCurrentWidth(event);
        int barWidth = this.calculateBarWidth(gc, this.calcTargetColumnCurrentWidth(event));
        int barHeight = this.calculateBarHeight(this.lastRowHeight);
        gc.setBackground(display.getSystemColor(15));
        gc.fillRectangle(this.lastRowX + 4, this.lastRowY + 4, barWidth, barHeight);
        this.drawBarOutline(gc, display, barWidth, barHeight);
        this.drawText(text, gc, display, event, columnWidth, 131072);
    }

    protected abstract Color allocateEmptyBarColour(Display var1);

    protected abstract Color allocateFullBarColour(Display var1);

    protected void disposeEmptyBarColour(Color color) {
    }

    protected void disposeFullBarColour(Color color) {
    }
}

