/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testrunexplorer.nodes;

import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.nodes.NodeRelationship;
import org.openclover.eclipse.core.views.nodes.NodeRelationshipFilter;
import org.openclover.eclipse.core.views.nodes.Nodes;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.TestCaseNodeFactory;
import org.openclover.util.Lists;

public class TypeToTestInnerTypeAndTestMethodRelationship
extends NodeRelationship {
    private TestCaseNodeFactory tcnFactory;

    public TypeToTestInnerTypeAndTestMethodRelationship(TestCaseNodeFactory tcnFactory) {
        this.tcnFactory = tcnFactory;
    }

    @Override
    public Object[] getChildren(Object object, NodeRelationshipFilter filter) {
        try {
            IType[] types = ((IType)object).getTypes();
            LinkedList children = Lists.newLinkedList();
            for (IType type : types) {
                if (!Nodes.containsTestCases(type)) continue;
                children.add(type);
            }
            return filter.perform(Nodes.collectTestCases((IType)object, children, (Nodes.TestCaseConverter)new Nodes.ToTestCaseNodeCoverter(this.tcnFactory)));
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to collect inner-types in type " + object, e);
            return new Object[0];
        }
    }

    @Override
    public Boolean hasChildren(Object object, NodeRelationshipFilter filter) {
        try {
            IType[] types = ((IType)object).getTypes();
            IMethod[] methods = ((IType)object).getMethods();
            for (IType iType : types) {
                FullClassInfo hasMetricsType = (FullClassInfo)MetricsScope.TEST_ONLY.getHasMetricsFor(iType, FullClassInfo.class);
                if (hasMetricsType == null || !hasMetricsType.isTestClass()) continue;
                return Boolean.TRUE;
            }
            for (IType iType : methods) {
                TestCaseInfo testCaseInfo = MetricsScope.TEST_ONLY.getTestCaseInfoFor((IMethod)iType);
                if (testCaseInfo == null) continue;
                return Boolean.TRUE;
            }
        }
        catch (JavaModelException e) {
            CloverPlugin.logError("Unable to count inner-types in type " + object, e);
        }
        return Boolean.FALSE;
    }

    @Override
    public boolean includes(Object object) {
        return object instanceof IType;
    }
}

