/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testrunexplorer.nodes;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.views.nodes.NodeRelationship;
import org.openclover.eclipse.core.views.nodes.NodeRelationshipFilter;
import org.openclover.eclipse.core.views.nodes.PackageFragmentNode;
import org.openclover.util.Lists;
import org.openclover.util.Sets;

public class PkgFragToTypeRelationship
extends NodeRelationship {
    @Override
    public Object[] getChildren(Object object, NodeRelationshipFilter filter) {
        try {
            List<IPackageFragment> packageFragments = this.toPackageFragments(object);
            LinkedHashSet compilationUnits = Sets.newLinkedHashSet();
            for (IPackageFragment packageFragment : packageFragments) {
                if (!packageFragment.exists()) continue;
                compilationUnits.addAll(this.collectTypes(packageFragment.getCompilationUnits()));
            }
            return filter.perform(compilationUnits);
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to meta-collect compilation units of package fragment " + object, e);
            return new Object[0];
        }
    }

    private Collection<IType> collectTypes(ICompilationUnit[] compilationUnits) throws JavaModelException {
        LinkedList<IType> types = Lists.newLinkedList();
        for (ICompilationUnit compilationUnit : compilationUnits) {
            types.addAll(Arrays.asList(compilationUnit.getAllTypes()));
        }
        return types;
    }

    private List<IPackageFragment> toPackageFragments(Object object) {
        return object instanceof PackageFragmentNode ? Lists.newLinkedList(((PackageFragmentNode)object).getPackageFragments()) : Collections.singletonList((IPackageFragment)object);
    }

    @Override
    public boolean includes(Object object) {
        return object instanceof IPackageFragment || object instanceof PackageFragmentNode;
    }
}

