/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testrunexplorer;

import java.util.Arrays;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.ColumnCollectionSettings;
import org.openclover.eclipse.core.views.ExplorerViewSettings;
import org.openclover.eclipse.core.views.nodes.NodeHierarchyBuilder;
import org.openclover.eclipse.core.views.testrunexplorer.TestRunExplorerView;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.FlatTestCasesHierarchyBuilder;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.PackageRootsHierarchyBuilder;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.PackagesHierarchyBuilder;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.TestCaseNodeFactory;

public class TestRunExplorerViewSettings
extends ExplorerViewSettings {
    public static final int HIERARCHY_STYLE_START = 0;
    public static final int HIERARCHY_STYLE_PACKAGE_ROOTS = 0;
    public static final int HIERARCHY_STYLE_PACKAGES = 1;
    public static final int HIERARCHY_STYLE_FLAT_TEST_CASES = 2;
    public static final int HIERARCHY_STYLE_MAX = 2;
    private TestCaseNodeFactory tcnFactory;
    private ColumnCollectionSettings classesTestedTreeSettings;

    public TestRunExplorerViewSettings(IMemento memento, TestCaseNodeFactory tcnFactory) {
        super(memento);
        this.classesTestedTreeSettings = new ColumnCollectionSettings("ClassesTested", memento, this.allClassesTestedTreeColumns(), this.defaultClassesTestedTreeColumns(), this.defaultClassesTestedTreeColumnWidths());
        this.tcnFactory = tcnFactory;
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.classesTestedTreeSettings.saveState(memento);
    }

    @Override
    protected List allTreeColumns() {
        return Arrays.asList(TestRunExplorerView.TESTCASE_BUILTIN_COLUMN_DEFINITIONS);
    }

    @Override
    protected List defaultTreeColumns() {
        return Arrays.asList(TestRunExplorerView.DEFAULT_TESTCASE_BUILTIN_COLUMN_DEFINITIONS);
    }

    @Override
    protected List defaultTreeColumnWidths() {
        return Arrays.asList(200, 100, 50, 75, 200);
    }

    private List defaultClassesTestedTreeColumnWidths() {
        return Arrays.asList(150, 125, 100);
    }

    private List allClassesTestedTreeColumns() {
        return Arrays.asList(TestRunExplorerView.ALL_BUILTIN_CONTRIB_COLUMNS);
    }

    private List defaultClassesTestedTreeColumns() {
        return Arrays.asList(TestRunExplorerView.DEFAULT_BUILTIN_CONTRIB_COLUMNS);
    }

    @Override
    public MetricsScope getMetricsScope() {
        return MetricsScope.TEST_ONLY;
    }

    @Override
    protected NodeHierarchyBuilder[] getNodeBuilders() {
        return new NodeHierarchyBuilder[]{new PackageRootsHierarchyBuilder(this.tcnFactory), new PackagesHierarchyBuilder(this.tcnFactory), new FlatTestCasesHierarchyBuilder(this.tcnFactory)};
    }

    @Override
    protected int expandDepthForStyle() {
        switch (this.hierarchyStyle) {
            case 0: {
                return 5;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
        }
        return 2;
    }

    @Override
    protected int getHierarchyStyleMax() {
        return 2;
    }

    @Override
    protected int getHierarchyStyleStart() {
        return 0;
    }

    @Override
    protected int defaultHierarchyStyle() {
        return 2;
    }

    public ColumnCollectionSettings getClassesTestedTreeSettings() {
        return this.classesTestedTreeSettings;
    }
}

