/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testrunexplorer;

import com.atlassian.clover.BitSetCoverageProvider;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.nodes.Nodes;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.ClassCoverageContributionNode;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.CoverageContributionNode;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.MethodCoverageContributionNode;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.TestCaseNode;
import org.openclover.util.Lists;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class ClassesTestedTreeProvider
extends WorkbenchContentProvider
implements ISelectionChangedListener {
    private TreeViewer treeViewer;
    private Object input;
    private List classes;
    private final Map methods = Maps.newHashMap();
    private boolean includeCoverageFromFailedTests = true;

    public ClassesTestedTreeProvider(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.input = newInput;
        this.classes = null;
        this.methods.clear();
    }

    public Object[] getElements(Object parent) {
        try {
            if (this.classes == null) {
                List testCases = this.removeFailed(!this.includeCoverageFromFailedTests, Nodes.collectTestCases(parent, Nodes.TO_TESTCASEINFO));
                CloverProject selectedTestCloverProject = CloverProject.getFor(this.asJavaElement(parent).getJavaProject());
                this.classes = selectedTestCloverProject != null && testCases.size() > 0 ? this.collectTestedClassesFor(Lists.newLinkedList(), testCases, selectedTestCloverProject) : Collections.emptyList();
            }
            return this.classes.toArray();
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to find tested methods for " + parent, e);
            return new Object[0];
        }
    }

    private List collectTestedClassesFor(final List testedClassInfos, List testCases, final CloverProject project) throws CoreException {
        FullProjectInfo fullProject;
        CloverProject[] dependencies;
        for (CloverProject dependency : dependencies = project.getDependencies()) {
            this.collectTestedClassesFor(testedClassInfos, testCases, dependency);
        }
        CloverDatabase database = project.getModel().getDatabase();
        FullProjectInfo appOnlyProject = database == null ? null : database.getAppOnlyModel();
        FullProjectInfo fullProjectInfo = fullProject = database == null ? null : database.getFullModel();
        if (database != null && appOnlyProject != null) {
            HashSet<TestCaseInfo> testCasesSet = Sets.newHashSet(testCases);
            CoverageData data = database.getCoverageData();
            final BitSetCoverageProvider testHits = new BitSetCoverageProvider(data.getHitsFor(testCasesSet), data);
            final BitSetCoverageProvider uniqueTestHits = new BitSetCoverageProvider(data.getUniqueHitsFor(testCasesSet), data);
            appOnlyProject.getClasses(new HasMetricsFilter(){

                @Override
                public boolean accept(HasMetrics hm) {
                    FullClassInfo classInfo = (FullClassInfo)hm;
                    try {
                        IType clazz = project.getJavaProject().findType(classInfo.getQualifiedName(), (IProgressMonitor)null);
                        if (clazz != null) {
                            ClassesTestedTreeProvider.this.maybeAddCoverageContributionNode(NodeBuilder.FOR_CLASSES, classInfo, (IJavaElement)clazz, classInfo.copy((FullFileInfo)classInfo.getContainingFile(), HasMetricsFilter.ACCEPT_ALL), testHits, uniqueTestHits, testedClassInfos);
                        }
                    }
                    catch (Exception e) {
                        CloverPlugin.logError("Unable to calculate classes tested", e);
                    }
                    return false;
                }
            });
        }
        return testedClassInfos;
    }

    private List collectTestedMethodsFor(IType javaType, CoverageDataProvider testHits, CoverageDataProvider uniqueTestHits) throws CoreException {
        FullClassInfo classInfo = (FullClassInfo)MetricsScope.APP_ONLY.getHasMetricsFor(javaType, FullClassInfo.class);
        ArrayList testedMethodInfos = Collections.emptyList();
        if (classInfo != null && (testedMethodInfos = (ArrayList)this.methods.get(classInfo)) == null) {
            testedMethodInfos = Lists.newArrayList();
            this.methods.put(classInfo, testedMethodInfos);
            IMethod[] methods = javaType.getMethods();
            if (javaType != null && methods.length > 0) {
                for (IMethod method : methods) {
                    FullMethodInfo methodInfo = (FullMethodInfo)MetricsScope.APP_ONLY.getHasMetricsFor(method, FullMethodInfo.class);
                    if (methodInfo == null) continue;
                    this.maybeAddCoverageContributionNode(NodeBuilder.FOR_METHODS, methodInfo, (IJavaElement)method, methodInfo.copy(classInfo), testHits, uniqueTestHits, testedMethodInfos);
                }
            }
        }
        return testedMethodInfos;
    }

    private void maybeAddCoverageContributionNode(NodeBuilder builder, HasMetrics hasMetrics, IJavaElement element, HasMetrics hasMetricsCopy, CoverageDataProvider testHits, CoverageDataProvider uniqueTestHits, List testedClassInfos) {
        float elementCoverage = this.calculateCoverage(hasMetricsCopy, testHits);
        if (elementCoverage > 0.0f) {
            testedClassInfos.add(builder.build(element, elementCoverage, this.calculateCoverage(hasMetricsCopy, uniqueTestHits), testHits, uniqueTestHits));
        }
    }

    private float calculateCoverage(HasMetrics hasMetricsCopy, CoverageDataProvider testHits) {
        int totalElements = hasMetricsCopy.getMetrics().getNumElements();
        ((CoverageDataReceptor)((Object)hasMetricsCopy)).setDataProvider(testHits);
        if (totalElements == 0) {
            if (hasMetricsCopy instanceof MethodInfo) {
                FullMethodInfo method = (FullMethodInfo)hasMetricsCopy;
                return method.getHitCount() == 0 ? 0.0f : 1.0f;
            }
            return 0.0f;
        }
        return (float)hasMetricsCopy.getMetrics().getNumCoveredElements() / (float)totalElements;
    }

    private List<MethodInfo> getTestMethods(List<TestCaseInfo> testCases, CloverDatabase database) {
        LinkedList<MethodInfo> testCaseMethods = Lists.newLinkedList();
        for (TestCaseInfo testInTestProject : testCases) {
            TestCaseInfo testInDependentProject = database.getTestCase(testInTestProject.getId());
            if (testInDependentProject == null || testInDependentProject.getSourceMethod() == null) continue;
            testCaseMethods.add(testInDependentProject.getSourceMethod());
        }
        return testCaseMethods;
    }

    private List removeFailed(boolean doIt, List testCaseInfos) {
        if (doIt) {
            Iterator iter = testCaseInfos.iterator();
            while (iter.hasNext()) {
                if (((TestCaseInfo)iter.next()).isSuccess()) continue;
                iter.remove();
            }
        }
        return testCaseInfos;
    }

    private IJavaElement asJavaElement(Object element) {
        if (element instanceof IJavaElement) {
            return (IJavaElement)element;
        }
        if (element instanceof TestCaseNode) {
            return ((TestCaseNode)element).toJavaElement();
        }
        if (element instanceof IAdaptable) {
            return (IJavaElement)((IAdaptable)element).getAdapter(IJavaElement.class);
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        try {
            if (o instanceof ClassCoverageContributionNode) {
                ClassCoverageContributionNode classContributionNode = (ClassCoverageContributionNode)o;
                return this.collectTestedMethodsFor((IType)classContributionNode.getElement(), classContributionNode.getTestHits(), classContributionNode.getUniqueTestHits()).toArray();
            }
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to calculate methods tested", e);
        }
        return new Object[0];
    }

    public boolean hasChildren(Object o) {
        return this.getChildren(o).length > 0;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            final Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ClassesTestedTreeProvider.this.treeViewer.setInput(ClassesTestedTreeProvider.this.asJavaElement(selection) == null ? null : selection);
                }
            });
        }
    }

    private static interface NodeBuilder {
        public static final NodeBuilder FOR_CLASSES = new NodeBuilder(){

            @Override
            public CoverageContributionNode build(IJavaElement element, float testContribution, float uniqueTestContribution, CoverageDataProvider testHits, CoverageDataProvider uniqueTestHits) {
                return new ClassCoverageContributionNode((IType)element, testContribution, uniqueTestContribution, testHits, uniqueTestHits);
            }
        };
        public static final NodeBuilder FOR_METHODS = new NodeBuilder(){

            @Override
            public CoverageContributionNode build(IJavaElement element, float testContribution, float uniqueTestContribution, CoverageDataProvider testHits, CoverageDataProvider uniqueTestHits) {
                return new MethodCoverageContributionNode((IMethod)element, testContribution, uniqueTestContribution, testHits, uniqueTestHits);
            }
        };

        public CoverageContributionNode build(IJavaElement var1, float var2, float var3, CoverageDataProvider var4, CoverageDataProvider var5);
    }
}

