/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testcontributions;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.views.CloverViewPart;
import org.openclover.eclipse.core.views.testcontributions.ActiveEditorListener;
import org.openclover.eclipse.core.views.testcontributions.AllTestContributionsFilterWidget;
import org.openclover.eclipse.core.views.testcontributions.LineTestContributionsWidget;
import org.openclover.eclipse.core.views.widgets.ViewAlertContainer;

public class TestContributionsView
extends CloverViewPart {
    public static final String ID = "org.openclover.eclipse.core.views.testcontributions";
    private ActiveEditorListener editorListener;
    private AllTestContributionsFilterWidget allTestsWidget;
    private AllTestContributionsFilterWidget.Settings allTestWidgetSettings;
    private LineTestContributionsWidget lineTestsWidget;
    private LineTestContributionsWidget.Settings lineTestsWidgetSettings;
    private static final int ACTION_OPEN = 0;
    private static final int ACTION_MAX = 1;

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.allTestWidgetSettings = new AllTestContributionsFilterWidget.Settings();
        this.lineTestsWidgetSettings = new LineTestContributionsWidget.Settings();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.allTestWidgetSettings = new AllTestContributionsFilterWidget.Settings(memento);
        this.lineTestsWidgetSettings = new LineTestContributionsWidget.Settings(memento);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.alertContainer = new ViewAlertContainer(parent);
        this.mainContent = new SashForm((Composite)this.alertContainer, this.calcViewOrientation());
        this.mainContent.setLayoutData((Object)new GridData(1808));
        this.alertContainer.setContent(this.mainContent);
        this.createAllTestsWidget((Composite)this.mainContent);
        this.createLineTestsWidget((Composite)this.mainContent);
        this.mainContent.setWeights(new int[]{5, 3});
        this.alertContainer.updateLinks();
        this.createActiveEditorListener();
        this.allTestsWidget.startTrackingEditor();
        this.lineTestsWidget.startTrackingEditor();
        CloverPlugin.getInstance().getCoverageMonitor().addCoverageChangeListener(this.alertContainer);
    }

    private void createLineTestsWidget(Composite parent) {
        this.lineTestsWidget = new LineTestContributionsWidget(this.lineTestsWidgetSettings, (ViewPart)this, parent, 0, 3840, true);
    }

    private void createAllTestsWidget(Composite parent) {
        this.allTestsWidget = new AllTestContributionsFilterWidget(this.allTestWidgetSettings, (ViewPart)this, parent, 0, 0x1000B00, true);
    }

    private void createActiveEditorListener() {
        this.editorListener = new ActiveEditorListener(this);
    }

    public void setFocus() {
        this.allTestsWidget.getTree().setFocus();
    }

    public void dispose() {
        if (this.editorListener != null) {
            this.editorListener.dispose();
        }
        if (this.allTestsWidget != null) {
            this.allTestsWidget.dispose();
        }
        if (this.lineTestsWidget != null) {
            this.lineTestsWidget.dispose();
        }
        if (this.alertContainer != null) {
            CloverPlugin.getInstance().getCoverageMonitor().removeCoverageChangeListener(this.alertContainer);
        }
        super.dispose();
    }

    public void setEnabled(boolean enabled) {
        this.allTestsWidget.setEnabled(enabled);
        this.lineTestsWidget.setEnabled(enabled);
    }

    public void setEditor(ITextEditor editor) {
        this.allTestsWidget.setEditor(editor);
        this.lineTestsWidget.setEditor(editor);
    }

    @Override
    protected int getAssumedViewOrientationIfUnknowable() {
        return 512;
    }
}

