/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testcontributions;

import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.openclover.eclipse.core.views.testcontributions.TestContributionsComputation;

public class TestCaseInfoProvider
implements ITreeContentProvider {
    protected Set<TestCaseInfo> testCases = Collections.emptySet();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        TestContributionsComputation contributionComputation = (TestContributionsComputation)((Object)newInput);
        if (contributionComputation != null) {
            this.testCases = contributionComputation.getTestCases();
        }
    }

    public void dispose() {
    }

    public Object[] getChildren(Object object) {
        if (object instanceof TestCaseInfo) {
            return new Object[0];
        }
        return this.getTestsFor((ClassInfo)object).toArray();
    }

    public Object getParent(Object object) {
        if (object instanceof TestCaseInfo) {
            return ((TestCaseInfo)object).getRuntimeType();
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return object instanceof ClassInfo;
    }

    public Object[] getElements(Object parent) {
        return this.getAllTestClasses().toArray();
    }

    public Set<TestCaseInfo> getAllTests() {
        return this.testCases;
    }

    public Set<FullClassInfo> getAllTestClasses() {
        HashSet<FullClassInfo> testClasses = new HashSet<FullClassInfo>(this.testCases.size());
        for (TestCaseInfo testCase : this.testCases) {
            if (!testCase.isResolved()) continue;
            testClasses.add(testCase.getRuntimeType());
        }
        return testClasses;
    }

    public Set<TestCaseInfo> getTestsFor(ClassInfo testClass) {
        HashSet<TestCaseInfo> testClasses = new HashSet<TestCaseInfo>(this.testCases.size());
        for (TestCaseInfo testCase : this.testCases) {
            if (testCase.getRuntimeType() != testClass) continue;
            testClasses.add(testCase);
        }
        return testClasses;
    }
}

