/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testcontributions;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.registry.entities.FullElementInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.ITextEditor;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.model.DatabaseModel;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotation;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotationModel;
import org.openclover.eclipse.core.views.testcontributions.TestContributionsComputation;

public class LineTestContributionsComputation
extends TestContributionsComputation {
    private static final QualifiedName CURSOR_POSITION = new QualifiedName("org.openclover.eclipse.core", "TestContributionsCursorLocation");

    public LineTestContributionsComputation() {
        super("Syncing test contributions for editor cursor");
    }

    @Override
    public void prime(ITextEditor editor) {
        DatabaseModel oldCoverageModel = this.getDatabaseModel();
        DatabaseModel newCoverageModel = this.databaseModelForEditor(editor);
        CoverageAnnotationModel oldCoverageAnnotationModel = this.getCoverageAnnotationModel();
        CoverageAnnotationModel newCoverageAnnotationModel = CoverageAnnotationModel.getModel(editor);
        Position oldPosition = this.getCursorPosition();
        Position newPosition = this.cursorPositionOfEditor(editor);
        if (oldCoverageModel != newCoverageModel || oldCoverageAnnotationModel != newCoverageAnnotationModel || !this.postionsEqual(oldPosition, newPosition)) {
            this.setDatabaseModel(newCoverageModel);
            this.setCoverageAnnotationModel(newCoverageAnnotationModel);
            this.setCursorPosition(newPosition);
            this.setInputChanged(true);
        } else {
            this.setInputChanged(false);
        }
    }

    private void setCursorPosition(Position newPosition) {
        this.setProperty(CURSOR_POSITION, newPosition);
    }

    private boolean postionsEqual(Position oldPosition, Position newPosition) {
        return !(oldPosition == null ^ newPosition == null) && (oldPosition == newPosition || oldPosition.equals((Object)newPosition));
    }

    private Position cursorPositionOfEditor(ITextEditor editor) {
        ISelection selection;
        if (editor != null && editor.getSelectionProvider() != null && (selection = editor.getSelectionProvider().getSelection()) instanceof ITextSelection) {
            return new Position(((ITextSelection)selection).getOffset(), ((ITextSelection)selection).getLength());
        }
        return null;
    }

    private Position getCursorPosition() {
        return (Position)this.getProperty(CURSOR_POSITION);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.isInputChanged()) {
                CoverageAnnotationModel coverageAnnotationModel = this.getCoverageAnnotationModel();
                DatabaseModel coverageModel = this.getDatabaseModel();
                Position cursorPosition = this.getCursorPosition();
                this.setTestCases(Collections.emptySet());
                if (coverageAnnotationModel != null && coverageModel != null && cursorPosition != null) {
                    this.updateTestCases(coverageAnnotationModel, coverageModel, cursorPosition);
                }
            }
        }
        catch (Exception e) {
            CloverPlugin.logError("Error while syning editor and contributing tests view", e);
        }
        return Status.OK_STATUS;
    }

    private void updateTestCases(CoverageAnnotationModel coverageAnnotationModel, DatabaseModel coverageModel, Position cursorPosition) {
        Iterator<Annotation> annotationIterator = coverageAnnotationModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            CloverDatabase database;
            CoverageAnnotation annotation = (CoverageAnnotation)annotationIterator.next();
            if (!annotation.encloses(cursorPosition.getOffset() + cursorPosition.getLength())) continue;
            FullElementInfo coveredElement = annotation.getInfo();
            if (coveredElement == null || (database = coverageModel.getDatabase()) == null) break;
            Set<TestCaseInfo> testHits = database.getTestHits(coveredElement);
            Iterator<TestCaseInfo> iterator = testHits.iterator();
            while (iterator.hasNext()) {
                TestCaseInfo testCase = iterator.next();
                if (testCase.isResolved() || testCase.resolve(MetricsScope.FULL.getProjectInfoFor(coverageModel.getDatabase()))) continue;
                iterator.remove();
            }
            this.setTestCases(testHits);
            break;
        }
    }
}

