/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testcontributions;

import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.texteditor.ITextEditor;
import org.openclover.eclipse.core.views.testcontributions.TestContributionsView;

public class ActiveEditorListener
implements IWindowListener,
IPartListener2,
IDisposable {
    private final IWorkbench workbench;
    private final TestContributionsView view;

    public ActiveEditorListener(TestContributionsView view) {
        this.view = view;
        this.workbench = view.getSite().getWorkbenchWindow().getWorkbench();
        for (IWorkbenchWindow window : this.workbench.getWorkbenchWindows()) {
            window.getPartService().addPartListener((IPartListener2)this);
        }
        this.workbench.addWindowListener((IWindowListener)this);
    }

    public void dispose() {
        this.workbench.removeWindowListener((IWindowListener)this);
        for (IWorkbenchWindow window : this.workbench.getWorkbenchWindows()) {
            window.getPartService().removePartListener((IPartListener2)this);
        }
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener2)this);
        this.updateView(window.getPartService().getActivePartReference());
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener2)this);
        this.view.setEditor(null);
    }

    public void partActivated(IWorkbenchPartReference partReference) {
        this.updateView(partReference);
    }

    private void updateView(IWorkbenchPartReference partReference) {
        ITextEditor editor;
        if (partReference != null && partReference.getPart(false) instanceof ITextEditor && (editor = (ITextEditor)partReference.getPart(false)) != null) {
            this.view.setEditor(editor);
        }
    }

    public void partDeactivated(IWorkbenchPartReference partReference) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partReference) {
    }

    public void partClosed(IWorkbenchPartReference partReference) {
    }

    public void partOpened(IWorkbenchPartReference partReference) {
    }

    public void partHidden(IWorkbenchPartReference partReference) {
    }

    public void partVisible(IWorkbenchPartReference partReference) {
    }

    public void partInputChanged(IWorkbenchPartReference partReference) {
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }
}

