/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.nodes;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.views.nodes.NodeRelationship;
import org.openclover.eclipse.core.views.nodes.NodeRelationshipFilter;
import org.openclover.util.Lists;

public class WorkspaceToCloveredProjRelationship
extends NodeRelationship {
    @Override
    public Object[] getChildren(Object object, NodeRelationshipFilter filter) {
        try {
            IWorkspace workspace = (IWorkspace)object;
            ArrayList<IProject> projects = Lists.newArrayList(workspace.getRoot().getProjects());
            Iterator projectsIterator = projects.iterator();
            while (projectsIterator.hasNext()) {
                IProject project = (IProject)projectsIterator.next();
                CloverProject cloverProject = CloverProject.getFor(project);
                if (cloverProject != null) continue;
                projectsIterator.remove();
            }
            return filter.perform(projects);
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to retrieve children for parent " + object, e);
            return new Object[0];
        }
    }

    @Override
    public boolean includes(Object object) {
        return object instanceof IWorkspace;
    }
}

