/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.dashboard;

import clover.org.apache.velocity.VelocityContext;
import clover.org.apache.velocity.app.VelocityEngine;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.html.VelocityLogAdapter;
import com.atlassian.clover.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.openclover.eclipse.core.views.dashboard.DashboardHtmlRenderingSupport;
import org.openclover.eclipse.core.views.dashboard.PlainTextVelocityResourceLoader;
import org.openclover.eclipse.core.views.dashboard.RenderEclipseDashboardAction;

public class DashboardGenerator {
    private static final String DASHBOARD_FILE = "dashboard-eclipse.html";
    private final CloverDatabase database;
    private final File basePath;
    private final File dashboardFile;
    private static final String DASHBOARD_VM = "html/dashboard-eclipse.vm";

    public DashboardGenerator(CloverDatabase database, File basePath) {
        this.database = database;
        this.basePath = basePath;
        this.dashboardFile = new File(basePath, DASHBOARD_FILE);
    }

    public void execute() throws Exception {
        this.createResources();
        VelocityContext context = new VelocityContext();
        context.put("baseUrl", this.getBaseURL());
        context.put("rootRelPath", "");
        context.put("showSrc", Boolean.TRUE);
        context.put("skipCoverageTreeMap", Boolean.TRUE);
        Current currentConfig = new Current();
        currentConfig.setShowLambdaFunctions(false);
        currentConfig.setShowLambdaFunctions(false);
        new RenderEclipseDashboardAction(context, this.basePath, this.database.getAppOnlyModel(), this.database.getFullModel(), null, null, currentConfig).applyCtxChanges();
        context.put("renderUtil", new DashboardHtmlRenderingSupport());
        DashboardGenerator.mergePlainTextTemplateToFile(this.dashboardFile, context, DASHBOARD_VM);
    }

    static void mergePlainTextTemplateToFile(File outfile, VelocityContext context, String template) throws Exception {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loader", "class");
        engine.setProperty("velocimacro.library", "");
        engine.setProperty("class.resource.loader.class", PlainTextVelocityResourceLoader.class.getName());
        engine.setProperty("class.resource.loader.cache", "true");
        engine.setProperty("class.resource.loader.modificationCheckInterval", "0");
        engine.setProperty("parser.pool.size", "1");
        engine.setProperty("runtime.log.logsystem", new VelocityLogAdapter(Logger.getInstance()));
        engine.setProperty("resource.manager.logwhenfound", "false");
        engine.setProperty("runtime.log.invalid.references", "false");
        engine.init();
        HtmlReportUtil.mergeTemplateToFile(engine, outfile, context, template);
    }

    public String getDashboardURL() {
        try {
            return this.dashboardFile.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getBaseURL() {
        try {
            return this.basePath.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void createResources() throws Exception {
        String templatePath = HtmlReportUtil.getTemplatePath();
        this.copyStaticResource(templatePath, "aui/css/aui.min.css");
        this.copyStaticResource(templatePath, "aui/css/aui-experimental.min.css");
        this.copyStaticResource(templatePath, "aui/css/aui-ie9.min.css");
        this.copyStaticResource(templatePath, "aui/css/atlassian-icons.eot");
        this.copyStaticResource(templatePath, "aui/css/atlassian-icons.svg");
        this.copyStaticResource(templatePath, "aui/css/atlassian-icons.ttf");
        this.copyStaticResource(templatePath, "aui/css/atlassian-icons.woff");
        this.copyStaticResource(templatePath, "aui/js/aui.min.js");
        this.copyStaticResource(templatePath, "aui/js/aui-datepicker.min.js");
        this.copyStaticResource(templatePath, "aui/js/aui-experimental.min.js");
        this.copyStaticResource(templatePath, "aui/js/aui-soy.min.js");
        this.copyStaticResource(templatePath, "clover.js");
        this.copyStaticResource(templatePath, "jquery-1.8.3.min.js");
        this.copyStaticResource(templatePath, "style.css");
    }

    private void copyStaticResource(String aLoadPath, String aName) throws IOException {
        File outfile = new File(this.basePath, aName);
        FileUtils.resourceToFile(this.getClass().getClassLoader(), aLoadPath + "/" + aName, outfile);
    }

    static {
        PlainTextVelocityResourceLoader.addPlainTextResource(DASHBOARD_VM);
        PlainTextVelocityResourceLoader.addPlainTextResource("html_res/adg/test-results-bar.vm");
        PlainTextVelocityResourceLoader.addPlainTextResource("html_res/adg/test-noresults-warning.vm");
        PlainTextVelocityResourceLoader.addPlainTextResource("html_res/adg/html-head.vm");
    }
}

