/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.coverageexplorer;

import com.atlassian.clover.reporters.Columns;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.ui.SwtUtils;
import org.openclover.eclipse.core.views.BuiltinColumnDefinition;
import org.openclover.eclipse.core.views.BuiltinDecimalMetricsColumnDefinition;
import org.openclover.eclipse.core.views.BuiltinIntegralMetricsColumnDefinition;
import org.openclover.eclipse.core.views.BuiltinPcMetricsColumnDefinition;
import org.openclover.eclipse.core.views.CloveredWorkspaceProvider;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.ExplorerView;
import org.openclover.eclipse.core.views.ExplorerViewComparator;
import org.openclover.eclipse.core.views.ExplorerViewLabelProvider;
import org.openclover.eclipse.core.views.ExplorerViewSettings;
import org.openclover.eclipse.core.views.coverageexplorer.CoverageProvider;
import org.openclover.eclipse.core.views.coverageexplorer.CoverageViewLabelProvider;
import org.openclover.eclipse.core.views.coverageexplorer.CoverageViewMetricsPane;
import org.openclover.eclipse.core.views.coverageexplorer.CoverageViewSettings;
import org.openclover.eclipse.core.views.coverageexplorer.CoverageViewTreeComparator;
import org.openclover.eclipse.core.views.coverageexplorer.widgets.InstallationSettingsDialog;
import org.openclover.eclipse.core.views.coverageexplorer.widgets.ProjectSettingsDialog;
import org.openclover.eclipse.core.views.nodes.PackageFragmentNode;
import org.openclover.eclipse.core.views.widgets.LinkedProjectRenderer;
import org.openclover.eclipse.core.views.widgets.ListeningRenderer;
import org.openclover.util.Lists;

public class CoverageView
extends ExplorerView
implements IShowInTarget {
    public static final String ID = "org.openclover.eclipse.core.views.CloverView";
    public static final ColumnDefinition COL_ELEMENT = new BuiltinColumnDefinition("CoverageElementName", 0, 16384, CloverEclipsePluginMessages.COVERAGE_ELEMENT_COL(), CloverEclipsePluginMessages.COVERAGE_ELEMENT_ABBREVIATED_COL(), CloverEclipsePluginMessages.COVERAGE_ELEMENT_COL_TOOL_TIP()){

        @Override
        public String getLabel(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
            return delegate.getText(element);
        }

        @Override
        public Image getImage(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
            return delegate.getImage(element);
        }

        @Override
        public boolean displaysSimpleLabel() {
            return true;
        }

        @Override
        public boolean displaysImage() {
            return true;
        }

        @Override
        public Comparator getComparator(ExplorerViewSettings settings, MetricsScope scope) {
            return COL_ELEMENT_COMPARATOR;
        }

        @Override
        public ListeningRenderer newRenderer(Composite composite, ExplorerViewSettings settings) {
            return new LinkedProjectRenderer(composite, settings.getTreeColumnSettings(), this);
        }
    };
    public static final Comparator COL_ELEMENT_COMPARATOR = new Comparator(){

        public int compare(Object object1, Object object2) {
            if (object1.getClass() == object2.getClass()) {
                return ExplorerViewComparator.compareName(object1, object2);
            }
            return ExplorerViewComparator.compareType(object1, object2);
        }
    };
    public static final ColumnDefinition COL_COVERAGE = new BuiltinPcMetricsColumnDefinition(new Columns.TotalPercentageCovered(), "Cov%", -1, 131072);
    public static final ColumnDefinition COL_TOTAL_ELEMENTS = new BuiltinIntegralMetricsColumnDefinition(new Columns.TotalElements(), "El", -1, 131072);
    public static final ColumnDefinition COL_COVERED_ELEMENTS = new BuiltinPcMetricsColumnDefinition(new Columns.CoveredElements(), "Cov El%", -1, 131072);
    public static final ColumnDefinition COL_TOTAL_BRANCHES = new BuiltinIntegralMetricsColumnDefinition(new Columns.TotalBranches(), "Br", -1, 131072);
    public static final ColumnDefinition COL_COVERED_BRANCHES = new BuiltinPcMetricsColumnDefinition(new Columns.CoveredBranches(), "Cov Br%", -1, 131072);
    public static final ColumnDefinition COL_TOTAL_STATEMENTS = new BuiltinIntegralMetricsColumnDefinition(new Columns.TotalStatements(), "St", -1, 131072);
    public static final ColumnDefinition COL_COVERED_STATEMENTS = new BuiltinPcMetricsColumnDefinition(new Columns.CoveredStatements(), "Cov St%", -1, 131072);
    public static final ColumnDefinition COL_TOTAL_METHODS = new BuiltinIntegralMetricsColumnDefinition(new Columns.TotalMethods(), "Me", -1, 131072);
    public static final ColumnDefinition COL_COVERED_METHODS = new BuiltinPcMetricsColumnDefinition(new Columns.CoveredMethods(), "Cov Me%", -1, 131072);
    public static final ColumnDefinition COL_TOTAL_CHILDREN = new BuiltinIntegralMetricsColumnDefinition(new Columns.TotalChildren(), "Kids", -1, 131072);
    public static final ColumnDefinition COL_COMPLEXITY = new BuiltinDecimalMetricsColumnDefinition(new Columns.Complexity(), "Cpx", -1, 131072);
    public static final ColumnDefinition COL_AVG_METH_COMPLEXITY = new BuiltinDecimalMetricsColumnDefinition(new Columns.AvgMethodComplexity(), "Av Me Cpx", -1, 131072);
    public static final ColumnDefinition COL_COMPLEXITY_DENSITY = new BuiltinDecimalMetricsColumnDefinition(new Columns.ComplexityDensity(), "Cpx Dns", -1, 131072);
    public static final ColumnDefinition COL_AVG_CLASSES_PER_FILE = new BuiltinDecimalMetricsColumnDefinition(new Columns.AvgClassesPerFile(), "Av Cl/Fi", -1, 131072);
    public static final ColumnDefinition COL_AVG_METHODS_PER_CLASS = new BuiltinDecimalMetricsColumnDefinition(new Columns.AvgMethodsPerClass(), "Av Me/Cl", -1, 131072);
    public static final ColumnDefinition COL_AVG_STATEMENTS_PER_METHOD = new BuiltinDecimalMetricsColumnDefinition(new Columns.AvgStatementsPerMethod(), "Av St/Me", -1, 131072);
    public static final ColumnDefinition COL_TOTAL_FILES = new BuiltinIntegralMetricsColumnDefinition(new Columns.TotalFiles(), "Fi", -1, 131072);
    public static final ColumnDefinition COL_TOTAL_CLASSES = new BuiltinIntegralMetricsColumnDefinition(new Columns.TotalClasses(), "Cl", -1, 131072);
    public static final ColumnDefinition COL_LINE_COUNT = new BuiltinIntegralMetricsColumnDefinition(new Columns.LineCount(), "LOC", -1, 131072);
    public static final ColumnDefinition COL_NC_LINE_COUNT = new BuiltinIntegralMetricsColumnDefinition(new Columns.NcLineCount(), "NCLOC", -1, 131072);
    public static final ColumnDefinition COL_UNCOVERED_BRANCHES = new BuiltinPcMetricsColumnDefinition(new Columns.UncoveredBranches(), "Ucov Br%", -1, 131072);
    public static final ColumnDefinition COL_UNCOVERED_STATEMENTS = new BuiltinPcMetricsColumnDefinition(new Columns.UncoveredStatements(), "Ucov St%", -1, 131072);
    public static final ColumnDefinition COL_UNCOVERED_METHODS = new BuiltinPcMetricsColumnDefinition(new Columns.UncoveredMethods(), "Ucov Me%", -1, 131072);
    public static final ColumnDefinition COL_UNCOVERED_ELEMENTS = new BuiltinPcMetricsColumnDefinition(new Columns.UncoveredElements(), "Ucov El%", -1, 131072);
    public static final ColumnDefinition COL_SUM = new BuiltinDecimalMetricsColumnDefinition(new Columns.SUM(), "SUM", -1, 131072);
    public static final ColumnDefinition COL_COVERED_CONTRIBUTION = new BuiltinPcMetricsColumnDefinition(new Columns.PercentageCoveredContribution(), "%Cov Ctrb", -1, 131072);
    public static final ColumnDefinition COL_UNCOVERED_CONTRIBUTION = new BuiltinPcMetricsColumnDefinition(new Columns.PercentageUncoveredContribution(), "%Ucov Ctrb", -1, 131072);
    public static final ColumnDefinition[] BUILTIN_COLUMN_DEFINITIONS = new ColumnDefinition[]{COL_ELEMENT, COL_COVERAGE, COL_TOTAL_ELEMENTS, COL_COVERED_ELEMENTS, COL_TOTAL_BRANCHES, COL_COVERED_BRANCHES, COL_TOTAL_STATEMENTS, COL_COVERED_STATEMENTS, COL_TOTAL_METHODS, COL_COVERED_METHODS, COL_TOTAL_CHILDREN, COL_COMPLEXITY, COL_AVG_METH_COMPLEXITY, COL_COMPLEXITY_DENSITY, COL_AVG_CLASSES_PER_FILE, COL_AVG_METHODS_PER_CLASS, COL_AVG_STATEMENTS_PER_METHOD, COL_TOTAL_FILES, COL_TOTAL_CLASSES, COL_LINE_COUNT, COL_NC_LINE_COUNT, COL_UNCOVERED_BRANCHES, COL_UNCOVERED_STATEMENTS, COL_UNCOVERED_METHODS, COL_UNCOVERED_ELEMENTS, COL_SUM, COL_COVERED_CONTRIBUTION, COL_UNCOVERED_CONTRIBUTION};
    public static final ColumnDefinition[] DEFAULT_BUILTIN_COLUMN_DEFINITIONS = new ColumnDefinition[]{COL_ELEMENT, COL_COVERAGE, COL_AVG_METH_COMPLEXITY, COL_COMPLEXITY};
    private static final int POPUP_OFFSET = 10;
    public static final int ACTION_OPEN = 0;
    public static final int ACTION_MAX = 1;
    private CoverageViewMetricsPane selectionPane;
    private Composite explorerTreePane;
    private Combo modelSelectionCombo;
    private Link settingsLink;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.settings = new CoverageViewSettings(memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.settings.saveState(memento);
    }

    @Override
    protected void buildRightHandSide() {
        this.selectionPane = new CoverageViewMetricsPane((Composite)this.mainContent, 0, this.getSettings(), this.treeViewer);
        this.updateMainContentSashOrientation(this.calcViewOrientation());
    }

    @Override
    protected void updateMainContentSashOrientation(int viewOrientation) {
        super.updateMainContentSashOrientation(viewOrientation);
        switch (viewOrientation) {
            case 512: {
                this.mainContent.setWeights(new int[]{7, 3});
                break;
            }
            default: {
                this.mainContent.setWeights(new int[]{2, 1});
            }
        }
    }

    @Override
    protected void buildTree() {
        this.explorerTreePane = new Composite((Composite)this.mainContent, 0);
        this.explorerTreePane.setLayout((Layout)new GridLayout(3, false));
        new Label(this.explorerTreePane, 0).setText("Show:");
        this.modelSelectionCombo = new Combo(this.explorerTreePane, 8);
        this.modelSelectionCombo.add("All classes");
        this.modelSelectionCombo.add("Application classes");
        this.modelSelectionCombo.add("Test classes");
        this.modelSelectionCombo.select(this.getSettings().getCoverageModel());
        this.modelSelectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CoverageView.this.setCoverageModel(CoverageView.this.modelSelectionCombo.getSelectionIndex());
            }
        });
        this.settingsLink = new Link(this.explorerTreePane, 0);
        this.settingsLink.setText("<a>Settings</a>");
        this.settingsLink.setLayoutData((Object)new GridData(128));
        this.settingsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                new InstallationSettingsDialog(CoverageView.this.getSite().getShell(), CoverageView.this.settingsLink.toDisplay(((CoverageView)CoverageView.this).settingsLink.getBounds().width + 10, 0)).open();
            }
        });
        super.buildTree();
        this.tree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                Point mousePoint = new Point(event.x, event.y);
                TreeItem item = CoverageView.this.tree.getItem(mousePoint);
                if (item != null && item.getData() instanceof IProject && item.getBounds(0).contains(mousePoint) && CoverageView.this.textBoundsFor(item, 0).contains(mousePoint)) {
                    CoverageView.this.tree.setCursor(CoverageView.this.tree.getDisplay().getSystemCursor(21));
                    return;
                }
                CoverageView.this.tree.setCursor(null);
            }
        });
        this.tree.setLayoutData((Object)new GridData(1808));
        SwtUtils.setHorizontalSpan((Control)this.tree, 3);
        this.tree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle textBounds;
                TreeItem item;
                Point point;
                CloverProject cloverProject;
                if (event.button == 1 && (cloverProject = CoverageView.this.getCloverProjectElementAtSelected(point = new Point(event.x, event.y), item = CoverageView.this.tree.getItem(point))) != null && (textBounds = CoverageView.this.textBoundsFor(item, 0)).contains(point)) {
                    CoverageView.this.showProjectSettingsPopup(cloverProject, textBounds);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle textBoundsFor(TreeItem item, int columnIndex) {
        GC gc = new GC((Drawable)this.tree);
        try {
            Point textSize;
            try {
                gc.setFont(item.getFont(columnIndex));
                textSize = gc.textExtent(item.getText(columnIndex));
            }
            finally {
                gc.dispose();
            }
            Rectangle imageBounds = item.getImageBounds(columnIndex);
            Point textTopLeft = new Point(imageBounds.x + imageBounds.width + 5, imageBounds.y);
            Rectangle rectangle = new Rectangle(textTopLeft.x, textTopLeft.y, textSize.x, textSize.y);
            return rectangle;
        }
        finally {
            gc.dispose();
        }
    }

    private CloverProject getCloverProjectElementAtSelected(Point point, TreeItem item) {
        if (item != null && item.getData() instanceof IProject && item.getBounds(0).contains(point)) {
            try {
                return CloverProject.getFor((IProject)item.getData());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    private void showProjectSettingsPopup(CloverProject project, Rectangle textBounds) {
        new ProjectSettingsDialog(this.getSite().getShell(), project, this.tree.toDisplay(textBounds.x + textBounds.width + 10, textBounds.y)).open();
    }

    @Override
    protected Composite getTreeParent() {
        return this.explorerTreePane;
    }

    @Override
    protected CloveredWorkspaceProvider newContentProvider() {
        return new CoverageProvider(this, this.getSettings());
    }

    @Override
    protected ExplorerViewLabelProvider newLabelProvider() {
        return new CoverageViewLabelProvider(this.getSettings());
    }

    @Override
    protected ViewerComparator newTreeViewComparator() {
        return CoverageViewTreeComparator.createFor(this.getSettings());
    }

    protected CoverageViewSettings getSettings() {
        return (CoverageViewSettings)this.settings;
    }

    private CoverageProvider getProvider() {
        return (CoverageProvider)this.treeContentProvider;
    }

    public int getCoverageModel() {
        return this.getSettings().getCoverageModel();
    }

    public void setCoverageModel(int model) {
        this.modelSelectionCombo.select(model);
        this.getSettings().setCoverageModel(model);
        this.refresh();
    }

    public void setShouldHideUnavailableCoverage(boolean shouldHide) {
        this.getSettings().setShouldHideUnavailableCoverage(shouldHide);
        this.refresh();
    }

    public void setShouldHideFullyCovered(boolean shouldHide) {
        this.getSettings().setShouldHideFullyCovered(shouldHide);
        this.refresh();
    }

    public boolean shouldHideUnavailableCoverage() {
        return this.getSettings().shouldHideUnavailableCoverage();
    }

    public boolean shouldHideFullyCovered() {
        return this.getSettings().shouldHideFullyCovered();
    }

    @Override
    protected TreeViewer buildSelectionProvider() {
        return this.treeViewer;
    }

    public ColumnDefinition[] getBuiltinColumnDefinitions() {
        return BUILTIN_COLUMN_DEFINITIONS;
    }

    public ColumnDefinition[] getDefaultBuiltinColumnDefinitions() {
        return DEFAULT_BUILTIN_COLUMN_DEFINITIONS;
    }

    @Override
    protected void buildToolbarStructure() {
        IToolBarManager toolbarMenuManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarMenuManager.add((IContributionItem)new Separator("project.ops"));
        toolbarMenuManager.add((IContributionItem)new Separator());
        toolbarMenuManager.add((IContributionItem)new Separator("project.reports"));
        toolbarMenuManager.add((IAction)this.generateReportAction);
        toolbarMenuManager.add((IContributionItem)new Separator());
        toolbarMenuManager.add((IContributionItem)new Separator("view.declutter"));
        toolbarMenuManager.add((IContributionItem)new Separator());
        toolbarMenuManager.add((IContributionItem)new Separator("view.hierarchy"));
        toolbarMenuManager.add((IContributionItem)new Separator());
        toolbarMenuManager.add((IContributionItem)new Separator("view.columns"));
        toolbarMenuManager.add((IContributionItem)new Separator());
        toolbarMenuManager.add((IContributionItem)new Separator("editor.ops"));
        toolbarMenuManager.add((IContributionItem)new Separator());
        toolbarMenuManager.add((IContributionItem)new Separator("additions"));
    }

    @Override
    protected void buildMenubarStructure() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("project.ops"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("project.reports"));
        menuManager.add((IAction)this.generateReportAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("view.coverage.ops.menu"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("view.workingset"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("view.declutter"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("view.hierarchy.menu"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("view.columns"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("editor.ops.menu"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    public boolean show(ShowInContext showInContext) {
        ISelection selection = showInContext.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            return this.selectInTree(((IStructuredSelection)selection).getFirstElement());
        }
        return this.selectInTree(showInContext.getInput());
    }

    private boolean selectInTree(Object input) {
        IJavaElement javaElement;
        if (input instanceof IAdaptable && (javaElement = (IJavaElement)((IAdaptable)input).getAdapter(IJavaElement.class)) != null) {
            this.selectInTree(javaElement);
            return true;
        }
        return false;
    }

    private void selectInTree(IJavaElement javaElement) {
        LinkedList path = Lists.newLinkedList();
        while (javaElement != null && !(javaElement instanceof IJavaProject)) {
            Object treeRepresentation = this.getTreeRepresentationFor(javaElement);
            if (treeRepresentation != null) {
                path.add(treeRepresentation);
            }
            javaElement = javaElement.getParent();
        }
        if (javaElement instanceof IJavaProject) {
            path.add(javaElement.getJavaProject().getProject());
        }
        Collections.reverse(path);
        Iterator iterator = path.iterator();
        while (iterator.hasNext()) {
            Object node = iterator.next();
            this.getTreeViewer().reveal(node);
            this.getTreeViewer().expandToLevel(node, 1);
            if (!this.getTreeViewer().getExpandedState(node) && iterator.hasNext()) continue;
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection(node), true);
        }
    }

    private Object getTreeRepresentationFor(Object node) {
        if (node instanceof IProject || node instanceof IPackageFragmentRoot || node instanceof ICompilationUnit || node instanceof IType || node instanceof IMethod) {
            return node;
        }
        if (node instanceof IPackageFragment && this.getSettings().getHierarchyStyle() == 1) {
            Object[] multiPackageFragments = ((ITreeContentProvider)this.getTreeViewer().getContentProvider()).getChildren((Object)((IPackageFragment)node).getJavaProject().getProject());
            PackageFragmentNode selectedMultiPackFrag = null;
            for (Object multiPackageFragment : multiPackageFragments) {
                PackageFragmentNode multPackFrag;
                if (!(multiPackageFragment instanceof PackageFragmentNode) || !(multPackFrag = (PackageFragmentNode)multiPackageFragment).getPackageFragments().contains(node)) continue;
                selectedMultiPackFrag = multPackFrag;
                break;
            }
            return selectedMultiPackFrag;
        }
        return null;
    }

    public void showPackageTree(boolean show) {
        this.getSettings().showPackageTree(show);
        this.treeContentProvider.setNodeBuilder(this.settings.nodeBuilderForStyle());
        this.refresh(false);
    }

    public boolean showPackageTree() {
        return this.getSettings().showPackageTree();
    }
}

