/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.actions;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.ui.projects.widgets.ToggleCloverProjectsDialog;
import org.openclover.eclipse.core.views.actions.CloverViewActionDelegate;

public class ToggleMultipleCloverProjectNaturesActionDelegate
extends CloverViewActionDelegate
implements IObjectActionDelegate {
    private IWorkbenchPart part;

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.part = part;
    }

    public IWorkbenchPage getPage() {
        return this.part == null ? this.view.getViewSite().getPage() : this.part.getSite().getPage();
    }

    public void run(IAction action) {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        final ToggleCloverProjectsDialog dialog = new ToggleCloverProjectsDialog(shell);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (dialog.open() == 0) {
                    Set toToggle = dialog.getProjectsToToggle();
                    Iterator iterator = toToggle.iterator();
                    while (iterator.hasNext()) {
                        CloverProject.toggleWithUserFeedback(shell, (IProject)iterator.next());
                    }
                    try {
                        if (CloverPlugin.getInstance().getInstallationSettings().isAutoOpenCloverViews() && toToggle.size() > 0) {
                            CloverPlugin.getInstance().showViews(ToggleMultipleCloverProjectNaturesActionDelegate.this.getPage());
                        }
                    }
                    catch (CoreException e) {
                        CloverPlugin.logError("Unable to show views after toggling Clover on " + toToggle.size() + " projects", e);
                    }
                }
            }
        });
    }
}

