/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.views.actions.SingleCloverProjectActionDelegate;

public class ToggleCloverCompilerActionDelegate
extends SingleCloverProjectActionDelegate {
    @Override
    protected void updateStateForSelection(IAction action) {
        super.updateStateForSelection(action);
        if (action.isEnabled()) {
            try {
                CloverProject project = CloverProject.getFor((IProject)this.projects.iterator().next());
                action.setChecked(project.getSettings().isInstrumentationEnabled());
            }
            catch (CoreException e) {
                CloverPlugin.logError("Unable to check/uncheck " + ((Object)((Object)this)).getClass().getName(), e);
            }
        }
    }

    public void run(IAction action) {
        try {
            CloverProject project = CloverProject.getFor((IProject)this.projects.iterator().next());
            if (project != null) {
                project.getSettings().setInstrumentationEnabled(action.isChecked());
                CloverPlugin.getInstance().getCoverageMonitor().fireCoverageChange(project);
                if (project.okayToRebuild(this.getShell())) {
                    project.getProject().build(15, null);
                }
            }
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to toggle Clover compiler", e);
        }
    }
}

