/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.views.actions.CloverProjectActionDelegate;

public class MultiCloverProjectActionDelegate
extends CloverProjectActionDelegate {
    @Override
    protected void updateStateForSelection(IAction action) {
        try {
            if (this.projects.size() > 0 && this.projects.size() <= this.getMaxSelectedProjectCount()) {
                IProject project;
                boolean shouldEnable = true;
                Iterator iterator = this.projects.iterator();
                while (iterator.hasNext() && (shouldEnable &= this.enableFor(project = (IProject)iterator.next()))) {
                }
                action.setEnabled(shouldEnable);
            } else {
                action.setEnabled(false);
            }
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to enable/disable " + ((Object)((Object)this)).getClass().getName(), e);
            action.setEnabled(false);
        }
    }

    protected boolean enableFor(IProject project) throws CoreException {
        return CloverProject.isAppliedTo(project);
    }

    public int getMaxSelectedProjectCount() {
        return Integer.MAX_VALUE;
    }
}

