/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.actions;

import com.atlassian.clover.api.CloverException;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.builder.PathUtils;
import org.openclover.eclipse.core.ui.editors.cloud.EclipseCloudGenerator;

public abstract class GenerateCloudJob
extends Job {
    private IProject project;

    public GenerateCloudJob(IProject project) {
        super(CloverEclipsePluginMessages.GENERATING_CLOUD_FOR(project.getName()));
        this.project = project;
        this.setUser(true);
        this.setPriority(40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Generating cloud", 4);
            try {
                this.generateReport(monitor);
            }
            catch (Throwable e) {
                Status status = new Status(4, "org.openclover.eclipse.core", 0, CloverEclipsePluginMessages.FAILED_TO_GENERATE_CLOUD(), e);
                monitor.done();
                return status;
            }
            IStatus iStatus = this.activateEditor();
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract IStatus activateEditor();

    protected void generateReport(IProgressMonitor monitor) throws Exception, CloverException, IOException {
        new EclipseCloudGenerator(CloverProject.getFor(this.project).getModel().getDatabase(), this.ensureReportFolderCreated(monitor)).execute();
    }

    protected File ensureReportFolderCreated(IProgressMonitor monitor) throws CoreException {
        IFolder folder = CloverProject.getFor(this.project).getReportDir();
        if (!folder.exists()) {
            PathUtils.makeDerivedFolder(folder);
        }
        return folder.getLocation().toFile();
    }
}

