/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.openclover.util.Sets;

public class SelectionUtils {
    private SelectionUtils() {
    }

    public static Set<IProject> gatherProjectsForSelection(ISelection selection) {
        HashSet<IProject> projects = Sets.newHashSet();
        if (selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                IJavaElement selectedJavaElement = SelectionUtils.asJavaElement(iter.next());
                if (selectedJavaElement == null) continue;
                projects.add(selectedJavaElement.getJavaProject().getProject());
            }
        }
        return projects;
    }

    public static IJavaElement asJavaElement(Object element) {
        IJavaElement javaElement = null;
        if (element instanceof IJavaElement) {
            javaElement = (IJavaElement)element;
        } else if (element instanceof IAdaptable) {
            javaElement = (IJavaElement)((IAdaptable)element).getAdapter(IJavaElement.class);
        }
        return javaElement;
    }
}

