/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.openclover.eclipse.core.projects.CloveredProjectLabelProvider;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.ColumnCollectionSettings;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.ExplorerViewSettings;

public abstract class ExplorerViewLabelProvider
implements ITableLabelProvider {
    protected ILabelProvider delegate = new CloveredProjectLabelProvider();
    protected ColumnCollectionSettings columnSettings;
    protected ExplorerViewSettings settings;

    public ExplorerViewLabelProvider(ExplorerViewSettings settings, ColumnCollectionSettings columnSettings) {
        this.settings = settings;
        this.columnSettings = columnSettings;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ColumnDefinition column = this.columnSettings.columnForIndex(columnIndex);
        if (column == null) {
            return this.delegate.getImage(element);
        }
        if (column.displaysImage()) {
            return column.getImage(this.settings, this.getMetricsScope(), this.delegate, element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ColumnDefinition column = this.columnSettings.columnForIndex(columnIndex);
        if (column == null) {
            return this.delegate.getText(element);
        }
        if (column.displaysSimpleLabel()) {
            return column.getLabel(this.settings, this.getMetricsScope(), this.delegate, element);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
        this.delegate.addListener(listener);
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.delegate.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.delegate.removeListener(listener);
    }

    public MetricsScope getMetricsScope() {
        return this.settings.getMetricsScope();
    }
}

