/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views;

import clover.antlr.RecognitionException;
import clover.antlr.collections.AST;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.registry.metrics.BlockMetrics;
import com.atlassian.clover.reporters.CalcTreeWalker;
import com.atlassian.clover.reporters.ExpressionEvaluator;
import com.atlassian.clover.util.MetricsFormatUtils;
import java.util.Comparator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.ExplorerViewComparator;
import org.openclover.eclipse.core.views.ExplorerViewSettings;
import org.openclover.eclipse.core.views.NumericColumnDefinition;
import org.openclover.eclipse.core.views.coverageexplorer.MetricsPcCellRenderer;
import org.openclover.eclipse.core.views.coverageexplorer.MetricsRawCellRenderer;
import org.openclover.eclipse.core.views.widgets.ListeningRenderer;
import org.openclover.eclipse.core.views.widgets.SelectionAwareCellRenderer;

public class CustomColumnDefinition
extends ColumnDefinition
implements NumericColumnDefinition {
    public static final int RAW_FORMAT = 0;
    public static final int PC_FORMAT = 1;
    private static int INDEX = 0;
    private final String expression;
    private final AST expressionAST;
    private final CalcTreeWalker expressionWalker;
    private final int format;
    private final Comparator appOnlyComparator;
    private final Comparator testOnlyComparator;
    private final Comparator fullComparator;

    public static String idForIndex(int index) {
        return "Custom:" + index;
    }

    public static synchronized int nextIndex() {
        return INDEX++;
    }

    public CustomColumnDefinition(String id, String title, String abbreviatedTitle, String expression, int alignment, int format) throws CloverException {
        super(id, -1, alignment, title, abbreviatedTitle, "");
        this.format = format == 0 || format == 1 ? format : 0;
        this.expression = expression;
        this.expressionAST = ExpressionEvaluator.parse(expression, title).getAST();
        this.expressionWalker = new CalcTreeWalker();
        this.appOnlyComparator = new MyComparator(MetricsScope.APP_ONLY);
        this.testOnlyComparator = new MyComparator(MetricsScope.TEST_ONLY);
        this.fullComparator = new MyComparator(MetricsScope.FULL);
        try {
            this.expressionWalker.validate(this.expressionAST);
        }
        catch (RecognitionException e) {
            throw new CloverException(e);
        }
    }

    public CustomColumnDefinition(String title, String abbreviatedTitle, String expression, int aligment, int format) throws CloverException {
        this(CustomColumnDefinition.idForIndex(CustomColumnDefinition.nextIndex()), title, abbreviatedTitle, expression, aligment, format);
    }

    public int getFormat() {
        return this.format;
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    public double calculate(BlockMetrics metrics) throws RecognitionException {
        return new CalcTreeWalker().expr(this.expressionAST, metrics);
    }

    @Override
    public String getLabel(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
        BlockMetrics metrics = scope.getMetricsFor(element);
        if (metrics != null) {
            try {
                if (this.format == 0) {
                    return MetricsFormatUtils.formatMetricsDecimal(this.calculate(metrics));
                }
                return MetricsFormatUtils.formatMetricsPercent(this.calculate(metrics) / 100.0);
            }
            catch (Exception e) {
                return "Error";
            }
        }
        return "-";
    }

    @Override
    public Number getValue(MetricsScope scope, Object element) {
        BlockMetrics metrics = scope.getMetricsFor(element);
        if (metrics != null) {
            try {
                Double result = this.format == 0 ? this.calculate(metrics) : this.calculate(metrics) / 100.0;
                return result.isNaN() || result.isInfinite() ? NOT_AVAILABLE_DOUBLE : result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NOT_AVAILABLE_DOUBLE;
    }

    @Override
    public ListeningRenderer newRenderer(Composite composite, ExplorerViewSettings settings) {
        SelectionAwareCellRenderer renderer = null;
        if (this.format == 1) {
            renderer = new MetricsPcCellRenderer((Tree)composite, settings, settings.getTreeColumnSettings(), this);
        } else if (this.format == 0) {
            renderer = new MetricsRawCellRenderer((Tree)composite, settings, settings.getTreeColumnSettings(), this){

                @Override
                protected String formatValue(Object item) {
                    double value = this.valueFor(item);
                    return MetricsFormatUtils.formatMetricsDecimal(value);
                }

                @Override
                protected double valueFor(Object data) {
                    return ((NumericColumnDefinition)((Object)this.column)).getValue(this.viewSettings.getMetricsScope(), data).doubleValue();
                }
            };
        }
        return renderer;
    }

    @Override
    public Comparator getComparator(ExplorerViewSettings settings, MetricsScope scope) {
        if (scope == MetricsScope.APP_ONLY) {
            return this.appOnlyComparator;
        }
        if (scope == MetricsScope.TEST_ONLY) {
            return this.testOnlyComparator;
        }
        return this.fullComparator;
    }

    private class MyComparator
    implements Comparator {
        private MetricsScope scope;

        public MyComparator(MetricsScope scope) {
            this.scope = scope;
        }

        public int compare(Object object1, Object object2) {
            return ExplorerViewComparator.compareCustomColumn(this.scope, CustomColumnDefinition.this, object1, object2);
        }
    }
}

