/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.CustomColumnDefinition;
import org.openclover.util.Lists;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class ColumnCollectionSettings
implements IPersistable {
    private static final String SORTED_COLUMN = "sorted.column";
    private static final String REVERSE_SORT = "reverse.sort";
    private static final String VISIBLE_COLUMN_PREFIX = "visible.column.";
    private static final String VISIBLE_COLUMN_COUNT = "visible.column.count";
    private static final String COL_WIDTH_SUFFIX = ".width";
    private static final Integer DEFAULT_CUSTOM_COLUMN_WIDTH = 100;
    private List<ColumnDefinition> allBuiltinColumns;
    private Map<String, ColumnDefinition> allColumnsById;
    private Set<ColumnDefinition> visibleColumns;
    private Map<ColumnDefinition, Integer> visibleColumnsToWidths;
    private ColumnDefinition sortedColumn;
    private boolean reverseSort;
    private String propertyPrefix;

    public ColumnCollectionSettings(IMemento memento, List<ColumnDefinition> allBuiltinColumns, List<ColumnDefinition> defaultBuiltinColumns, List<Integer> defaultBuiltinWidths) {
        this("", memento, allBuiltinColumns, defaultBuiltinColumns, defaultBuiltinWidths);
    }

    public ColumnCollectionSettings(String propertyPrefix, IMemento memento, List<ColumnDefinition> allBuiltinColumns, List<ColumnDefinition> defaultBuiltinColumns, List<Integer> defaultBuiltinWidths) {
        this.allBuiltinColumns = Lists.newArrayList(allBuiltinColumns);
        this.buildDefaults(propertyPrefix, defaultBuiltinColumns, defaultBuiltinWidths);
        if (memento != null) {
            this.loadSortColumn(memento);
            this.loadReverseSort(memento);
            this.loadColumnWidths(memento);
        }
    }

    public void saveState(IMemento memento) {
        this.saveSortedColumn(memento);
        this.saveReverseSort(memento);
        this.saveColumnWidths(memento);
    }

    private void buildDefaults(String propertyPrefix, List<ColumnDefinition> defaultBuiltinColumns, List<Integer> defaultBuiltinWidths) {
        this.regenerateAllColumnsByIdMap();
        this.buildDefaultColumnWidths(defaultBuiltinColumns, defaultBuiltinWidths);
        this.sortedColumn = defaultBuiltinColumns.get(0);
        this.propertyPrefix = propertyPrefix;
        this.reverseSort = false;
    }

    private void buildDefaultColumnWidths(List<ColumnDefinition> defaultBuiltinColumns, List<Integer> defaultBuiltinWidths) {
        this.visibleColumns = Sets.newLinkedHashSet();
        this.visibleColumnsToWidths = Maps.newLinkedHashMap();
        for (int i = 0; i < defaultBuiltinColumns.size(); ++i) {
            this.visibleColumnsToWidths.put(defaultBuiltinColumns.get(i), defaultBuiltinWidths.get(i));
            this.visibleColumns.add(defaultBuiltinColumns.get(i));
        }
    }

    private void loadColumnWidths(IMemento memento) {
        Integer columnCount = memento.getInteger(this.prefixed(VISIBLE_COLUMN_COUNT));
        LinkedHashMap visibleColumnsToWidths = Maps.newLinkedHashMap();
        LinkedHashSet visibleColumns = Sets.newLinkedHashSet();
        if (columnCount != null && columnCount >= 0) {
            for (int i = 0; i < columnCount; ++i) {
                String columnId = memento.getString(this.prefixed(VISIBLE_COLUMN_PREFIX + i));
                ColumnDefinition column = columnId == null ? null : this.allColumnsById.get(columnId);
                Integer columnWidth = memento.getInteger(this.prefixed(VISIBLE_COLUMN_PREFIX + i + COL_WIDTH_SUFFIX));
                if (column == null || columnWidth == null || columnWidth <= 0) continue;
                visibleColumns.add(column);
                visibleColumnsToWidths.put(column, columnWidth);
            }
        }
        if (visibleColumnsToWidths.size() > 0) {
            this.visibleColumnsToWidths = visibleColumnsToWidths;
            this.visibleColumns = visibleColumns;
        }
    }

    private void loadReverseSort(IMemento memento) {
        String reverseSort = memento.getString(this.prefixed(REVERSE_SORT));
        if (reverseSort != null) {
            this.reverseSort = Boolean.parseBoolean(reverseSort);
        }
    }

    private void loadSortColumn(IMemento memento) {
        String sortedColumnId = memento.getString(this.prefixed(SORTED_COLUMN));
        if (sortedColumnId != null) {
            ColumnDefinition firstBuiltin = this.allBuiltinColumns.get(0);
            if (sortedColumnId.contains(":")) {
                this.sortedColumn = this.allColumnsById.get(sortedColumnId);
                this.sortedColumn = this.sortedColumn == null ? firstBuiltin : this.sortedColumn;
            } else {
                this.sortedColumn = firstBuiltin;
            }
        }
    }

    private void regenerateAllColumnsByIdMap() {
        HashMap allColumnsById = Maps.newHashMap();
        for (ColumnDefinition builtinColumn : this.allBuiltinColumns) {
            allColumnsById.put(builtinColumn.getId(), builtinColumn);
        }
        List<CustomColumnDefinition> customColumns = CloverPlugin.getInstance().getInstallationSettings().getCustomColumns();
        for (CustomColumnDefinition customColumn : customColumns) {
            allColumnsById.put(customColumn.getId(), customColumn);
        }
        this.allColumnsById = allColumnsById;
    }

    private void saveColumnWidths(IMemento memento) {
        memento.putInteger(this.prefixed(VISIBLE_COLUMN_COUNT), this.visibleColumnsToWidths.size());
        List<CustomColumnDefinition> customColumns = CloverPlugin.getInstance().getInstallationSettings().getCustomColumns();
        int count = 0;
        for (Map.Entry<ColumnDefinition, Integer> entry : this.visibleColumnsToWidths.entrySet()) {
            ColumnDefinition colDef = entry.getKey();
            if (colDef.isCustom()) {
                memento.putString(this.prefixed(VISIBLE_COLUMN_PREFIX + count), CustomColumnDefinition.idForIndex(customColumns.indexOf(colDef)));
            } else {
                memento.putString(this.prefixed(VISIBLE_COLUMN_PREFIX + count), colDef.getId());
            }
            memento.putInteger(this.prefixed(VISIBLE_COLUMN_PREFIX + count + COL_WIDTH_SUFFIX), entry.getValue().intValue());
            ++count;
        }
    }

    private void saveReverseSort(IMemento memento) {
        memento.putString(this.prefixed(REVERSE_SORT), Boolean.toString(this.reverseSort));
    }

    private void saveSortedColumn(IMemento memento) {
        memento.putString(this.prefixed(SORTED_COLUMN), this.sortedColumn.getId());
    }

    private String prefixed(String name) {
        return this.propertyPrefix + (this.propertyPrefix.length() > 0 ? "." : "") + name;
    }

    public void sortOn(ColumnDefinition columnDefinition) {
        this.reverseSort ^= this.sortedColumn == columnDefinition;
        this.sortedColumn = columnDefinition;
    }

    public List getVisibleColumns() {
        return Lists.newLinkedList(this.visibleColumnsToWidths.keySet());
    }

    public Map<ColumnDefinition, Integer> getVisibleColumnsToWidths() {
        return this.visibleColumnsToWidths;
    }

    public Set getAllColumns() {
        return Sets.newLinkedHashSet(this.allColumnsById.values());
    }

    public ColumnDefinition getSortedColumn() {
        return this.sortedColumn;
    }

    public boolean isReverseSort() {
        return this.reverseSort;
    }

    public int getVisibleColumnIndexFor(ColumnDefinition column) {
        return Lists.newArrayList(this.visibleColumns).indexOf(column);
    }

    public ColumnDefinition columnForIndex(int columnIndex) {
        return Lists.newArrayList(this.visibleColumns).get(columnIndex);
    }

    public void setVisibleColumnSize(ColumnDefinition column, int width) {
        this.visibleColumnsToWidths.put(column, width);
    }

    public void setColumnOrder(int[] orderIndicies) {
        ArrayList<ColumnDefinition> visibleColumns = Lists.newArrayList(this.visibleColumns);
        LinkedHashMap newVisibleColumnsToWidths = Maps.newLinkedHashMap();
        for (int orderIndicy : orderIndicies) {
            newVisibleColumnsToWidths.put(visibleColumns.get(orderIndicy), this.visibleColumnsToWidths.get(visibleColumns.get(orderIndicy)));
        }
        this.visibleColumnsToWidths = newVisibleColumnsToWidths;
    }

    public void update(CustomColumnDefinition[] customColumns, ColumnDefinition[] visibleColumns) {
        CloverPlugin.getInstance().getInstallationSettings().setCustomColumns(Arrays.asList(customColumns));
        this.regenerateAllColumnsByIdMap();
        LinkedHashSet newVisibleColumns = Sets.newLinkedHashSet();
        LinkedHashMap newVisibleColumnsToWidths = Maps.newLinkedHashMap();
        for (ColumnDefinition visibleColumn : visibleColumns) {
            Integer width = this.visibleColumnsToWidths.get(visibleColumn);
            width = width == null ? DEFAULT_CUSTOM_COLUMN_WIDTH : width;
            newVisibleColumnsToWidths.put(visibleColumn, width);
            newVisibleColumns.add(visibleColumn);
        }
        this.visibleColumnsToWidths = newVisibleColumnsToWidths;
        this.visibleColumns = newVisibleColumns;
        if (!this.allColumnsById.containsValue(this.sortedColumn)) {
            this.sortedColumn = this.allColumnsById.values().iterator().next();
            this.reverseSort = false;
        }
    }

    public List getAllBuiltinColumns() {
        return this.allBuiltinColumns;
    }
}

