/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.openclover.eclipse.core.views.widgets.ViewAlertContainer;

public abstract class CloverViewPart
extends ViewPart {
    protected Composite parent;
    protected ViewAlertContainer alertContainer;
    protected int viewOrientation;
    protected SashForm mainContent;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                int viewOrientation = CloverViewPart.this.calcViewOrientation();
                if (CloverViewPart.this.viewOrientation != viewOrientation) {
                    CloverViewPart.this.viewOrientation = viewOrientation;
                    CloverViewPart.this.onViewOrientationChange(viewOrientation);
                }
            }
        });
        this.viewOrientation = this.calcViewOrientation();
    }

    protected void onViewOrientationChange(int viewOrientation) {
        this.updateMainContentSashOrientation(viewOrientation);
    }

    protected int calcViewOrientation() {
        Point size = this.parent.getSize();
        if (size.x != 0 && size.y != 0) {
            if (size.x > size.y) {
                return 256;
            }
            return 512;
        }
        return this.getAssumedViewOrientationIfUnknowable();
    }

    protected abstract int getAssumedViewOrientationIfUnknowable();

    protected void updateMainContentSashOrientation(int viewOrientation) {
        this.mainContent.setOrientation(viewOrientation);
    }
}

