/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views;

import com.atlassian.clover.registry.metrics.BlockMetrics;
import com.atlassian.clover.registry.metrics.ClassMetrics;
import com.atlassian.clover.reporters.Column;
import java.util.Comparator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.BuiltinColumnDefinition;
import org.openclover.eclipse.core.views.ExplorerViewComparator;
import org.openclover.eclipse.core.views.ExplorerViewSettings;
import org.openclover.eclipse.core.views.NumericColumnDefinition;
import org.openclover.eclipse.core.views.coverageexplorer.CoverageViewSettings;
import org.openclover.eclipse.core.views.coverageexplorer.MetricsRawCellRenderer;
import org.openclover.eclipse.core.views.widgets.ListeningRenderer;

public abstract class BuiltinMetricsColumnDefinition
extends BuiltinColumnDefinition
implements NumericColumnDefinition {
    protected static final Double NOT_AVAILABLE_DOUBLE = -1.0;
    private final MetricsComparator appOnlyComparator = new MetricsComparator(MetricsScope.APP_ONLY);
    private final MetricsComparator testOnlyComparator = new MetricsComparator(MetricsScope.TEST_ONLY);
    private final MetricsComparator fullComparator = new MetricsComparator(MetricsScope.FULL);
    private final Column prototype;

    public BuiltinMetricsColumnDefinition(Column prototype, String abbreviatedTitle, int requiredIndex, int style) {
        super("Metrics" + prototype.getName(), requiredIndex, style, prototype.getTitle(), abbreviatedTitle, prototype.getHelp());
        this.prototype = prototype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLabel(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object target) {
        BlockMetrics metrics = scope.getMetricsFor(target);
        if (metrics != null) {
            try {
                Column column = this.prototype;
                synchronized (column) {
                    this.prototype.init(metrics);
                    return this.format(this.prototype.getNumber());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Number getValue(MetricsScope scope, Object object) {
        BlockMetrics metrics = scope.getMetricsFor(object);
        if (metrics != null) {
            try {
                Column column = this.prototype;
                synchronized (column) {
                    this.prototype.init(metrics);
                    return this.prototype.getNumber();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NOT_AVAILABLE_DOUBLE;
    }

    @Override
    public ListeningRenderer newRenderer(Composite composite, ExplorerViewSettings settings) {
        return new MetricsRawCellRenderer((Tree)composite, settings, settings.getTreeColumnSettings(), this){

            @Override
            protected String formatValue(Object item) {
                return BuiltinMetricsColumnDefinition.this.getLabel(this.viewSettings, this.viewSettings.getMetricsScope(), null, item);
            }
        };
    }

    protected abstract String format(Number var1);

    public Column getPrototype() {
        return this.prototype;
    }

    private static ClassMetrics toClassMetrics(BlockMetrics metrics1) {
        return metrics1 instanceof ClassMetrics ? (ClassMetrics)metrics1 : null;
    }

    private static BlockMetrics toMetrics(CoverageViewSettings settings, Object value) {
        return settings.getMetricsScope().getMetricsFor(value);
    }

    @Override
    public Comparator getComparator(ExplorerViewSettings settings, MetricsScope scope) {
        if (scope == MetricsScope.APP_ONLY) {
            return this.appOnlyComparator;
        }
        if (scope == MetricsScope.TEST_ONLY) {
            return this.testOnlyComparator;
        }
        return this.fullComparator;
    }

    public class MetricsComparator
    implements Comparator {
        private MetricsScope scope;

        public MetricsComparator(MetricsScope scope) {
            this.scope = scope;
        }

        public int compare(Object object1, Object object2) {
            if (object1.getClass() == object2.getClass()) {
                Double value1 = BuiltinMetricsColumnDefinition.this.getValue(this.scope, object1).doubleValue();
                Double value2 = BuiltinMetricsColumnDefinition.this.getValue(this.scope, object2).doubleValue();
                return value1.compareTo(value2);
            }
            return ExplorerViewComparator.compareType(object1, object2);
        }
    }
}

