/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.widgets;

import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.context.NamedContext;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.projects.settings.RegexpEntry;
import org.openclover.eclipse.core.ui.SwtUtils;
import org.openclover.eclipse.core.ui.widgets.RegexpFilterEditDialog;
import org.openclover.util.Lists;

public class RegexContextFilterModificationWidget
extends Composite {
    private Button addFilter;
    private Button removeFilter;
    private Button editFilter;
    private Button copyFilter;
    private org.eclipse.swt.widgets.List filterList;
    private List<RegexpEntry> regexps = Lists.newArrayList();
    private int regexpsLengthSinceLastStore;
    private ProjectSettings properties;

    public RegexContextFilterModificationWidget(Composite parent, ProjectSettings props) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        this.properties = props;
        Label regexExplanationLabel = new Label((Composite)this, 0);
        regexExplanationLabel.setText(CloverEclipsePluginMessages.REGEXP_CONTEXT_FILTER_MODIFICATION_INSTRUCTIONS());
        SwtUtils.gridDataFor((Control)regexExplanationLabel).horizontalSpan = 2;
        this.filterList = new org.eclipse.swt.widgets.List((Composite)this, 2820);
        GridData gd = SwtUtils.gridDataFor((Control)this.filterList);
        gd.verticalSpan = 5;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.addFilter = new Button((Composite)this, 8);
        this.addFilter.setText("Add");
        gd = SwtUtils.gridDataFor((Control)this.addFilter);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.removeFilter = new Button((Composite)this, 8);
        this.removeFilter.setText("Remove");
        this.removeFilter.setEnabled(false);
        gd = SwtUtils.gridDataFor((Control)this.removeFilter);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.editFilter = new Button((Composite)this, 8);
        this.editFilter.setText("Edit");
        this.editFilter.setEnabled(false);
        gd = SwtUtils.gridDataFor((Control)this.editFilter);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.copyFilter = new Button((Composite)this, 8);
        this.copyFilter.setText("Copy");
        this.copyFilter.setEnabled(false);
        gd = SwtUtils.gridDataFor((Control)this.copyFilter);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.addFilter.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    RegexContextFilterModificationWidget.this.doAdd();
                }
                catch (Exception e) {
                    CloverPlugin.logError("Error adding new regex", e);
                    RegexContextFilterModificationWidget.this.logRegexError(e);
                }
            }
        });
        this.removeFilter.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RegexContextFilterModificationWidget.this.doRemove();
            }
        });
        this.copyFilter.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    RegexContextFilterModificationWidget.this.doCopy();
                }
                catch (Exception e) {
                    CloverPlugin.logError("Error duplicating regex", e);
                    RegexContextFilterModificationWidget.this.logRegexError(e);
                }
            }
        });
        this.editFilter.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RegexContextFilterModificationWidget.this.doEdit();
            }
        });
        this.filterList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RegexContextFilterModificationWidget.this.doSelection();
            }
        });
        this.loadFrom(this.properties);
    }

    private void logRegexError(Exception e) {
        MessageDialog.openError((Shell)this.getShell(), (String)"Regular Expression Error", (String)("An error was found in the regular expressions: " + e.getMessage()));
    }

    private void loadFrom(ProjectSettings properties) {
        this.regexps = properties.getRegexpFilters();
        this.regexpsLengthSinceLastStore = this.regexps.size();
        this.refreshList();
        this.updateButtonStates();
    }

    private void refreshList() {
        this.filterList.removeAll();
        for (RegexpEntry r : this.regexps) {
            this.filterList.add(r.getName() + (r.isChanged() ? " (*)" : ""));
        }
        if (this.filterList.getItemCount() > 0) {
            this.filterList.setSelection(0);
        }
        this.filterList.redraw();
    }

    public void store() {
        this.properties.setRegexpFilters(this.regexps);
        ContextStore newReg = this.properties.getContextRegistry();
        ContextSet newFilter = this.properties.getContextFilter();
        for (RegexpEntry regexpEntry : this.regexps) {
            NamedContext newContext = newReg.getContext(regexpEntry.getName());
            if (newContext != null) {
                newFilter = newFilter.set(newContext.getIndex());
            }
            regexpEntry.setChanged(false);
        }
        this.properties.setContextFilter(newFilter);
        this.refreshList();
        this.regexpsLengthSinceLastStore = this.regexps.size();
    }

    public boolean isRebuildRequired() {
        boolean changed;
        block1: {
            RegexpEntry regexp;
            boolean bl = changed = this.regexpsLengthSinceLastStore != this.regexps.size();
            if (changed) break block1;
            Iterator<RegexpEntry> iterator = this.regexps.iterator();
            while (iterator.hasNext() && !(changed = (regexp = iterator.next()).isChanged())) {
            }
        }
        return changed;
    }

    private void doSelection() {
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.filterList.getSelectionCount() == 0) {
            this.editFilter.setEnabled(false);
            this.removeFilter.setEnabled(false);
            this.copyFilter.setEnabled(false);
        } else {
            this.editFilter.setEnabled(true);
            this.removeFilter.setEnabled(true);
            this.copyFilter.setEnabled(true);
        }
    }

    private void doAdd() {
        RegexpEntry newCtx = new RegexpEntry(RegexContextFilterModificationWidget.suggestNewName(this.regexps), "", 0);
        RegexpFilterEditDialog dialog = new RegexpFilterEditDialog(this.getShell(), this.regexps);
        dialog.setData(newCtx);
        int result = dialog.open();
        if (result != 1) {
            newCtx = dialog.getData();
            this.regexps.add(newCtx);
            this.filterList.add(newCtx.getName() + (newCtx.isChanged() ? " (*)" : ""), this.filterList.getItemCount());
            this.filterList.setSelection(this.filterList.getItemCount() - 1);
            this.updateButtonStates();
        }
    }

    private void doEdit() {
        if (!this.isItemSelected()) {
            return;
        }
        int index = this.filterList.getSelectionIndex();
        RegexpEntry data = this.regexps.get(index);
        RegexpFilterEditDialog dialog = new RegexpFilterEditDialog(this.getShell(), this.regexps);
        dialog.setData(data);
        int result = dialog.open();
        if (result == 1) {
            return;
        }
        RegexpEntry newData = dialog.getData();
        newData.setChanged(data.isChanged());
        if (!newData.equivalent(data)) {
            newData.setChanged(true);
        }
        this.regexps.set(index, newData);
        this.filterList.setItem(index, newData.getName() + (newData.isChanged() ? " (*)" : ""));
    }

    private void doRemove() {
        if (!this.isItemSelected()) {
            return;
        }
        int index = this.filterList.getSelectionIndex();
        this.filterList.remove(index);
        this.regexps.remove(index);
        if (this.filterList.getItemCount() == 0) {
            this.updateButtonStates();
            return;
        }
        if (index < this.filterList.getItemCount()) {
            this.filterList.setSelection(index);
        } else {
            this.filterList.setSelection(this.filterList.getItemCount() - 1);
        }
        this.updateButtonStates();
    }

    private void doCopy() {
        if (!this.isItemSelected()) {
            return;
        }
        int index = this.filterList.getSelectionIndex();
        RegexpEntry original = this.regexps.get(index);
        RegexpEntry copy = original.duplicate(RegexContextFilterModificationWidget.suggestCopyName(original, this.regexps));
        this.regexps.add(copy);
        this.filterList.add(copy.getName() + (copy.isChanged() ? " (*)" : ""), this.filterList.getItemCount());
        this.filterList.setSelection(this.filterList.getItemCount() - 1);
    }

    private boolean isItemSelected() {
        return this.filterList.getSelectionIndex() != -1;
    }

    private static String suggestNewName(List<RegexpEntry> existing) {
        return RegexContextFilterModificationWidget.suggestName("Unnamed_{0}", existing);
    }

    private static String suggestCopyName(RegexpEntry ctx, List<RegexpEntry> existing) {
        return RegexContextFilterModificationWidget.suggestName("Copy_{0}_of_" + ctx.getName(), existing);
    }

    private static String suggestName(String template, List<RegexpEntry> existing) {
        String regexp = MessageFormat.format(template, "(\\d+)");
        Pattern pattern = Pattern.compile(regexp);
        long maxIndex = 0L;
        for (RegexpEntry regex : existing) {
            long index;
            Matcher matcher = pattern.matcher(regex.getName());
            if (!matcher.matches() || (index = Long.parseLong(matcher.group(1))) <= maxIndex) continue;
            maxIndex = index;
        }
        return MessageFormat.format(template, maxIndex + 1L);
    }
}

