/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.widgets;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class MessageDialogWithCheckbox
extends MessageDialog {
    private Button mCheckBox;
    private final String mCheckText;
    private final boolean mInitialChecked;
    private boolean mCheckedValue;

    public MessageDialogWithCheckbox(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String checkText, boolean isChecked) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.mCheckText = checkText;
        this.mInitialChecked = isChecked;
    }

    protected Control createCustomArea(Composite parent) {
        new Label(parent, 0);
        this.mCheckBox = new Button(parent, 32);
        this.mCheckBox.setText(this.mCheckText);
        this.mCheckBox.setSelection(this.mInitialChecked);
        return this.mCheckBox;
    }

    public boolean close() {
        this.mCheckedValue = this.mCheckBox.getSelection();
        return super.close();
    }

    public static void openQuestion(Shell parent, String title, String message, boolean isYesSelected, String checkedText, boolean isChecked, Result result) {
        MessageDialogWithCheckbox dialog = new MessageDialogWithCheckbox(parent, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, isYesSelected ? 0 : 1, checkedText, isChecked);
        result.setYesSelected(dialog.open() == 0);
        result.checked = dialog.mCheckedValue;
    }

    public static class Result {
        private boolean yesSelected = true;
        private boolean checked;

        public boolean isYesSelected() {
            return this.yesSelected;
        }

        public void setYesSelected(boolean yesSelected) {
            this.yesSelected = yesSelected;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }
    }
}

