/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.widgets;

import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.context.MethodRegexpContext;
import com.atlassian.clover.context.NamedContext;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.util.Maps;

public class BuiltinContextFilterSelectionWidget
extends Composite {
    protected static final int CONTEXTS_PER_LINE = 3;
    private HashMap blockCheckboxes;
    private HashMap regexCheckboxes;
    protected ContextStore contextStore;
    protected ContextSet filter;

    public BuiltinContextFilterSelectionWidget(Composite parent, ContextStore contextStore, ContextSet filter) {
        super(parent, 0);
        this.setLayout((Layout)new RowLayout(512));
        this.blockCheckboxes = Maps.newHashMap();
        this.regexCheckboxes = Maps.newHashMap();
        this.contextStore = contextStore;
        this.filter = filter;
    }

    public void buildContents() {
        this.createBlockContextContainerWidget();
    }

    private Composite createBlockContextContainerWidget() {
        Label blockLabel = new Label((Composite)this, 16384);
        blockLabel.setText(CloverEclipsePluginMessages.BLOCK_CONTEXT_FILTER_INSTRUCTIONS());
        Composite container = new Composite((Composite)this, 0);
        container.setLayout((Layout)new GridLayout(3, true));
        List<NamedContext> reservedContexts = this.contextStore.getReservedContexts();
        for (NamedContext context : reservedContexts) {
            if (context.getIndex() == 0) continue;
            Button check = new Button(container, 32);
            check.setText(this.makeBlockContextUserFriendly(context.getName()));
            check.setSelection(false);
            this.blockCheckboxes.put(context.getName(), check);
        }
        List<MethodRegexpContext> reservedMethodContexts = this.contextStore.getReservedMethodContexts();
        for (MethodRegexpContext context : reservedMethodContexts) {
            Button check = new Button(container, 32);
            check.setText(this.makeRegexContextUserFriendly(context.getName()));
            check.setSelection(false);
            this.regexCheckboxes.put(context.getName(), check);
        }
        return container;
    }

    private String makeBlockContextUserFriendly(String contextName) {
        return CloverEclipsePluginMessages.RESERVED_BLOCK_CONTEXT(contextName);
    }

    private String makeRegexContextUserFriendly(String contextName) {
        return CloverEclipsePluginMessages.RESERVED_REGEX_CONTEXT(contextName);
    }

    public void updateSelection() {
        Button checkbox;
        NamedContext[] namedContexts;
        for (NamedContext namedContext : namedContexts = this.contextStore.getContexts(this.filter)) {
            checkbox = (Button)this.blockCheckboxes.get(namedContext.getName());
            if (checkbox == null) continue;
            checkbox.setSelection(true);
        }
        for (NamedContext namedContext : namedContexts) {
            checkbox = (Button)this.regexCheckboxes.get(namedContext.getName());
            if (checkbox == null) continue;
            checkbox.setSelection(true);
        }
    }

    public void storeTo(ProjectSettings properties) {
        properties.setContextFilter(this.getFilterFromSelection(properties.getContextFilter()));
    }

    public ContextSet getFilterFromSelection() {
        return this.getFilterFromSelection(new ContextSet());
    }

    public ContextSet getFilterFromSelection(ContextSet filter) {
        List<NamedContext> reservedContext = this.contextStore.getReservedContexts();
        for (NamedContext namedContext : reservedContext) {
            Button checkbox = (Button)this.blockCheckboxes.get(namedContext.getName());
            if (checkbox == null) continue;
            filter = filter.set(namedContext.getIndex(), checkbox.getSelection());
        }
        List<MethodRegexpContext> reservedMethodContext = this.contextStore.getReservedMethodContexts();
        for (MethodRegexpContext namedContext : reservedMethodContext) {
            Button checkbox = (Button)this.regexCheckboxes.get(namedContext.getName());
            if (checkbox == null) continue;
            filter = filter.set(namedContext.getIndex(), checkbox.getSelection());
        }
        return filter;
    }

    public boolean filtersHaveChangedSinceLastSave() {
        return !this.filter.equals(this.getFilterFromSelection());
    }
}

