/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.projects.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.CloveredProjectLabelProvider;
import org.openclover.eclipse.core.ui.CloverPluginIcons;
import org.openclover.eclipse.core.ui.SwtUtils;
import org.openclover.util.Lists;
import org.openclover.util.Sets;

public class ToggleCloverProjectsDialog
extends Dialog {
    private static final int CLOVER_PROJ_WARN_THRESHOLD = 4;
    private Table projectTable;
    private TableViewer projectTableViewer;
    private Set projectsToToggle = Sets.newHashSet();
    private LocalResourceManager resourceManager;
    private Composite warningComposite;
    private Label prompt;

    public ToggleCloverProjectsDialog(Shell shell) {
        super(shell);
        this.setShellStyle(68720);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Enable/Disable Clover on Projects");
    }

    protected Control createDialogArea(Composite parent) {
        TableItem[] items;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        Composite body = new Composite(parent, 0){

            public void dispose() {
                super.dispose();
                ToggleCloverProjectsDialog.this.resourceManager.dispose();
            }
        };
        body.setLayoutData((Object)new GridData(1808));
        body.setLayout((Layout)new GridLayout(3, false));
        ((GridLayout)body.getLayout()).horizontalSpacing = 10;
        ((GridLayout)body.getLayout()).verticalSpacing = 10;
        ((GridLayout)body.getLayout()).marginWidth = 10;
        ((GridLayout)body.getLayout()).marginHeight = 10;
        this.warningComposite = new Composite(body, 2048);
        this.warningComposite.setLayout((Layout)new GridLayout(2, false));
        this.warningComposite.setLayoutData((Object)new GridData(512));
        SwtUtils.gridDataFor((Control)this.warningComposite).horizontalSpan = 3;
        this.warningComposite.setBackground(this.getShell().getDisplay().getSystemColor(29));
        this.warningComposite.setVisible(false);
        Label warningImage = new Label(this.warningComposite, 0);
        warningImage.setImage(CloverPluginIcons.grabPluginImage((ResourceManager)this.resourceManager, "org.eclipse.ui", "icons/full/obj16/warn_tsk.gif"));
        SwtUtils.gridDataFor((Control)warningImage).verticalAlignment = 128;
        warningImage.setBackground(this.getShell().getDisplay().getSystemColor(29));
        Label warningLabel = new Label(this.warningComposite, 64);
        warningLabel.setText("Enabling Clover on large projects or lots of medium size projects consumes additional memory. We recommend you incrementally enable Clover a few projects at a time until you have determined the maximum number your current memory settings can handle.");
        warningLabel.setLayoutData((Object)new GridData(768));
        warningLabel.setBackground(this.getShell().getDisplay().getSystemColor(29));
        this.prompt = new Label(body, 0);
        this.prompt.setLayoutData((Object)new GridData(768));
        SwtUtils.gridDataFor((Control)this.prompt).horizontalSpan = 3;
        this.prompt.setText("Select the projects Clover should track code coverage for:");
        SwtUtils.gridDataFor((Control)this.warningComposite).widthHint = (int)((double)this.prompt.computeSize((int)-1, (int)-1).x * 1.5);
        this.projectTable = new Table(body, 2080);
        this.projectTable.setLayoutData((Object)new GridData(1808));
        SwtUtils.gridDataFor((Control)this.projectTable).horizontalSpan = 3;
        SwtUtils.gridDataFor((Control)this.projectTable).heightHint = 150;
        SwtUtils.gridDataFor((Control)this.projectTable).widthHint = 200;
        this.projectTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ToggleCloverProjectsDialog.this.updateWarning(true);
            }
        });
        this.projectTableViewer = new TableViewer(this.projectTable);
        this.projectTableViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object parent) {
                if (parent instanceof IProject) {
                    return null;
                }
                if (parent instanceof IWorkspace) {
                    ArrayList<IProject> projects = Lists.newArrayList(((IWorkspace)parent).getRoot().getProjects());
                    Iterator iter = projects.iterator();
                    while (iter.hasNext()) {
                        IProject project = (IProject)iter.next();
                        if (project.isAccessible() && JavaCore.create((IProject)project) != null && project.getName().indexOf(".") != 0) continue;
                        iter.remove();
                    }
                    return projects.toArray();
                }
                return super.getChildren(parent);
            }
        });
        this.projectTableViewer.setLabelProvider((IBaseLabelProvider)new CloveredProjectLabelProvider());
        this.projectTableViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        for (TableItem item : items = this.projectTable.getItems()) {
            try {
                if (!CloverProject.isAppliedTo((IProject)item.getData())) continue;
                item.setChecked(true);
            }
            catch (CoreException e) {
                CloverPlugin.logError("Error while checking Clover-enabled and disabled projects", e);
            }
        }
        Label filler = new Label(body, 0);
        filler.setLayoutData((Object)new GridData(768));
        Button selectAllButton = new Button(body, 0);
        selectAllButton.setText("Select all");
        SwtUtils.gridDataFor((Control)selectAllButton).horizontalAlignment = 3;
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToggleCloverProjectsDialog.this.setAllChecked(true);
            }
        });
        Button deselectAllButton = new Button(body, 0);
        deselectAllButton.setText("Deselect all");
        SwtUtils.gridDataFor((Control)deselectAllButton).horizontalAlignment = 3;
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToggleCloverProjectsDialog.this.setAllChecked(false);
            }
        });
        this.updateWarning(false);
        return body;
    }

    private void setAllChecked(boolean checked) {
        TableItem[] projectItems;
        for (TableItem projectItem : projectItems = this.projectTable.getItems()) {
            projectItem.setChecked(checked);
        }
        this.updateWarning(true);
    }

    protected void okPressed() {
        TableItem[] projectItems;
        for (TableItem projectItem : projectItems = this.projectTable.getItems()) {
            try {
                IProject project = (IProject)projectItem.getData();
                boolean checked = projectItem.getChecked();
                if ((!CloverProject.isAppliedTo(project) || checked) && (CloverProject.isAppliedTo(project) || !checked)) continue;
                this.projectsToToggle.add(project);
            }
            catch (CoreException e) {
                CloverPlugin.logError("Error determing projects to enable/disable", e);
            }
        }
        super.okPressed();
    }

    public Set getProjectsToToggle() {
        return this.projectsToToggle;
    }

    private void updateWarning(boolean layout) {
        if (this.getCheckedCount() > 4) {
            this.showWarning(layout);
        } else {
            this.hideWarning(layout);
        }
    }

    private int getCheckedCount() {
        TableItem[] items;
        int checked = 0;
        for (TableItem item : items = this.projectTable.getItems()) {
            if (!item.getChecked()) continue;
            ++checked;
        }
        return checked;
    }

    private void showWarning(boolean layout) {
        SwtUtils.gridDataFor((Control)this.warningComposite).exclude = false;
        if (layout) {
            ((Composite)this.getContents()).layout(true, true);
        }
        this.warningComposite.setVisible(true);
    }

    private void hideWarning(boolean layout) {
        SwtUtils.gridDataFor((Control)this.warningComposite).exclude = true;
        if (layout) {
            ((Composite)this.getContents()).layout(true, true);
        }
        this.warningComposite.setVisible(false);
    }
}

