/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.projects;

import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.DatabaseModel;
import org.openclover.eclipse.core.projects.model.LoadedDatabaseModel;
import org.openclover.eclipse.core.projects.model.LoadingDatabaseModel;
import org.openclover.eclipse.core.projects.model.StableDatabaseModel;

public class DatabaseChangeEvent {
    private final CloverProject project;
    private boolean forWorkspace;
    private boolean stable;
    private boolean substantive;

    public DatabaseChangeEvent(CloverProject project, DatabaseModel oldModel, DatabaseModel newModel) {
        this.project = project;
        this.forWorkspace = project == null;
        this.stable = newModel instanceof StableDatabaseModel;
        this.substantive = !(newModel instanceof LoadingDatabaseModel) || !(oldModel instanceof LoadedDatabaseModel);
    }

    public CloverProject getProject() {
        return this.project;
    }

    public boolean isApplicableTo(CloverProject cloverProject) {
        return this.forWorkspace || cloverProject == this.project;
    }

    public boolean isStable() {
        return this.stable;
    }

    public boolean isForWorkspace() {
        return this.forWorkspace;
    }

    public boolean isSubstantiveProjectChange() {
        return this.substantive;
    }
}

