/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.treemap;

import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.BasePackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import java.util.List;
import net.sf.jtreemap.ktreemap.TreeMapNode;
import net.sf.jtreemap.ktreemap.TreeMapNodeBuilder;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.MetricsScope;

public class ProjectHeatMapBuilder
extends TreeMapNodeBuilder {
    public TreeMapNode buildTree(CloverProject project) {
        FullProjectInfo projectInfo = MetricsScope.FULL.getProjectInfoFor(project);
        TreeMapNode root = this.buildBranch(projectInfo, null);
        List<? extends PackageInfo> packages = projectInfo.getAllPackages();
        for (PackageInfo packageInfo : packages) {
            BasePackageInfo basePackageInfo = (BasePackageInfo)packageInfo;
            TreeMapNode branch = this.buildBranch(basePackageInfo, root);
            List<? extends ClassInfo> classes = basePackageInfo.getClasses();
            for (ClassInfo classInfo : classes) {
                BaseClassInfo baseClassInfo = (BaseClassInfo)classInfo;
                this.buildLeaf(baseClassInfo, branch);
            }
        }
        return root;
    }

    @Override
    public double getWeight(Object value) {
        return value instanceof HasMetrics ? (double)((HasMetrics)value).getMetrics().getNumElements() : 0.0;
    }
}

