/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.treemap;

import com.atlassian.clover.api.registry.HasMetrics;
import java.util.List;
import net.sf.jtreemap.ktreemap.KTreeMap;
import net.sf.jtreemap.ktreemap.TreeMapNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.views.actions.OpenJavaEditorAction;

public class CloverTreeMap
extends KTreeMap {
    private OpenJavaEditorAction openEditorAction;

    public CloverTreeMap(final IJavaProject project, IWorkbenchPartSite site, Composite parent, int root, TreeMapNode strategy) {
        super(parent, root, strategy);
        this.openEditorAction = new OpenJavaEditorAction((IWorkbenchSite)site);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (CloverTreeMap.this.getActiveLeaf().isLeaf()) {
                    HasMetrics activeMetricsLeaf = (HasMetrics)CloverTreeMap.this.getActiveLeaf().getValue();
                    HasMetrics activeMetricsBranch = (HasMetrics)CloverTreeMap.this.getActiveLeaf().getParent().getValue();
                    try {
                        IType type;
                        IType iType = type = project == null ? null : project.findType(this.getPackageName(activeMetricsBranch) + activeMetricsLeaf.getName(), (IProgressMonitor)null);
                        if (type != null) {
                            CloverTreeMap.this.openEditorAction.run((IStructuredSelection)new StructuredSelection(type));
                        } else {
                            CloverPlugin.logWarning("Unable to open editor for treemap leaf: " + activeMetricsLeaf.getName());
                        }
                    }
                    catch (CoreException e) {
                        CloverPlugin.logError("Unable to open editor for treemap leaf: " + activeMetricsLeaf.getName(), e);
                    }
                }
            }

            private String getPackageName(HasMetrics hasMetrics) {
                return "default-pkg".equals(hasMetrics.getName()) ? "" : hasMetrics.getName() + ".";
            }
        });
    }

    @Override
    protected void drawLabels(GC gc, TreeMapNode item) {
        gc.setFont(this.getFont());
        if (!this.getDisplayedRoot().isLeaf()) {
            List<TreeMapNode> children = this.getDisplayedRoot().getChildren();
            for (TreeMapNode child : children) {
                this.drawLabel(gc, child);
            }
        }
    }

    @Override
    protected void drawLabel(GC gc, TreeMapNode item) {
        if (item.isLeaf()) {
            super.drawLabel(gc, item);
        } else {
            FontMetrics fm = gc.getFontMetrics();
            if (fm.getHeight() < item.getHeight() - 2) {
                String label = this.getTreeMapProvider().getLabel(item);
                int y = (item.getHeight() - fm.getAscent() - fm.getLeading() + fm.getDescent()) / 2;
                int stringWidth = fm.getAverageCharWidth() * label.length();
                if (item.getWidth() - 5 <= stringWidth) {
                    int nbChar = label.length() * item.getWidth() / stringWidth;
                    if (nbChar > 3) {
                        label = "..." + label.substring(Math.max(0, label.length() - 1 - nbChar), label.length());
                        stringWidth = (nbChar - 1) * fm.getAverageCharWidth();
                    } else {
                        return;
                    }
                }
                int x = (item.getWidth() - stringWidth) / 2;
                gc.setForeground(Display.getDefault().getSystemColor(2));
                gc.drawString(label, item.getX() + x + 1, item.getY() + y + 1, true);
                gc.drawString(label, item.getX() + x - 1, item.getY() + y + 1, true);
                gc.drawString(label, item.getX() + x + 1, item.getY() + y - 1, true);
                gc.drawString(label, item.getX() + x - 1, item.getY() + y - 1, true);
                gc.drawString(label, item.getX() + x + 1, item.getY() + y, true);
                gc.drawString(label, item.getX() + x - 1, item.getY() + y, true);
                gc.drawString(label, item.getX() + x, item.getY() + y + 1, true);
                gc.drawString(label, item.getX() + x, item.getY() + y - 1, true);
                gc.setForeground(this.getColorProvider().getForeground(item));
                gc.drawString(label, item.getX() + x, item.getY() + y, true);
            }
        }
    }
}

