/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotation;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.AnnotationSpaceWithFragments;
import org.openclover.util.Lists;

public abstract class AnnotationSpace {
    protected CloverDatabase database;
    protected IDocument document;
    protected Map<TestCaseInfo, BitSet> tcisAndHitsForFile;
    protected List<AnnotationSpaceWithFragments> childSpaces;
    protected boolean sealed;

    protected AnnotationSpace(CloverDatabase database, IDocument document, Map<TestCaseInfo, BitSet> tcisAndHitsForFile) {
        this.database = database;
        this.document = document;
        this.tcisAndHitsForFile = tcisAndHitsForFile;
        this.childSpaces = Lists.newLinkedList();
        this.sealed = false;
    }

    public AnnotationSpace newChildSpace(SourceInfo region, boolean hidden) throws BadLocationException {
        this.ensureNotSealed();
        AnnotationSpaceWithFragments newSpace = new AnnotationSpaceWithFragments(this.database, this.document, this.tcisAndHitsForFile, this, region, hidden);
        this.childSpaces.add(newSpace);
        return newSpace;
    }

    public AnnotationSpace seal(SourceInfo region, boolean hidden) throws BadLocationException {
        this.ensureNotSealed();
        this.sealed = true;
        for (int i = 0; i < this.childSpaces.size(); ++i) {
            AnnotationSpaceWithFragments annotationSpaceWithFragments = this.childSpaces.get(i);
            if (!annotationSpaceWithFragments.sealed) {
                throw new AssertionError((Object)("Child " + i + " not sealed: \n" + this));
            }
        }
        return this.getParent();
    }

    protected abstract AnnotationSpace getParent();

    public SortedSet<CoverageAnnotation> toAnnotations(SortedSet<CoverageAnnotation> set) {
        this.ensureSealed();
        for (AnnotationSpaceWithFragments childSpace : this.childSpaces) {
            childSpace.toAnnotations(set);
        }
        return set;
    }

    protected void ensureSealed() {
        if (!this.sealed) {
            throw new AssertionError((Object)("Node is not sealed: \n" + this));
        }
    }

    protected void ensureNotSealed() {
        if (this.sealed) {
            throw new AssertionError((Object)("Node is sealed: \n" + this));
        }
    }
}

