/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.java;

import java.util.Comparator;
import org.openclover.eclipse.core.ui.editors.java.CoverageBeginning;
import org.openclover.eclipse.core.ui.editors.java.CoverageEdge;
import org.openclover.eclipse.core.ui.editors.java.CoverageEnd;

class CoverageEdgeComparator
implements Comparator<CoverageEdge> {
    CoverageEdgeComparator() {
    }

    @Override
    public int compare(CoverageEdge o1, CoverageEdge o2) {
        if (o1 instanceof CoverageEnd && o2 instanceof CoverageBeginning || o1 instanceof CoverageBeginning && o2 instanceof CoverageEnd) {
            if (o1.getColumn() < o2.getColumn()) {
                return -1;
            }
            if (o1.getColumn() > o2.getColumn()) {
                return 1;
            }
            return o1 instanceof CoverageEnd ? -1 : 1;
        }
        if (o1 instanceof CoverageBeginning && o2 instanceof CoverageBeginning) {
            int startingColumn2;
            int startingLine2;
            int startingColumn1;
            int startingLine1 = o1.getInfo().getStartLine();
            int frontDisposition = this.disposition(startingLine1, startingColumn1 = o1.getInfo().getStartColumn(), startingLine2 = o2.getInfo().getStartLine(), startingColumn2 = o2.getInfo().getStartColumn());
            if (frontDisposition == 0) {
                int endingColumn2;
                int endingLine1 = o1.getInfo().getEndLine();
                int endingColumn1 = o1.getInfo().getEndColumn();
                int endingLine2 = o2.getInfo().getEndLine();
                int backDisposition = this.disposition(endingLine2, endingColumn2 = o2.getInfo().getEndColumn(), endingLine1, endingColumn1);
                if (backDisposition == 0) {
                    return this.compareIdentityHashCodeOfInfo(o1, o2);
                }
                return backDisposition;
            }
            return frontDisposition;
        }
        if (o1 instanceof CoverageEnd && o2 instanceof CoverageEnd) {
            int endingColumn2;
            int endingLine2;
            int endingColumn1;
            int endingLine1 = o1.getInfo().getEndLine();
            int backDisposition = this.disposition(endingLine1, endingColumn1 = o1.getInfo().getEndColumn(), endingLine2 = o2.getInfo().getEndLine(), endingColumn2 = o2.getInfo().getEndColumn());
            if (backDisposition == 0) {
                int startingColumn2;
                int startingLine1 = o1.getInfo().getStartLine();
                int startingColumn1 = o1.getInfo().getStartColumn();
                int startingLine2 = o2.getInfo().getStartLine();
                int frontDisposition = this.disposition(startingLine2, startingColumn2 = o2.getInfo().getStartColumn(), startingLine1, startingColumn1);
                if (frontDisposition == 0) {
                    return this.compareIdentityHashCodeOfInfo(o1, o2);
                }
                return frontDisposition;
            }
            return backDisposition;
        }
        throw new AssertionError((Object)"Edges should only be of type CoverageBeginning or CoverageEnding");
    }

    private int disposition(int startingLine1, int startingColumn1, int startingLine2, int startingColumn2) {
        if (startingLine1 < startingLine2) {
            return -1;
        }
        if (startingLine1 > startingLine2) {
            return 1;
        }
        return Integer.compare(startingColumn1, startingColumn2);
    }

    private int compareIdentityHashCodeOfInfo(CoverageEdge o1, CoverageEdge o2) {
        int hashCode2;
        int hashCode1 = System.identityHashCode(o1.getInfo());
        if (hashCode1 == (hashCode2 = System.identityHashCode(o2.getInfo()))) {
            return 0;
        }
        if (o1 instanceof CoverageBeginning && hashCode1 < hashCode2) {
            return -1;
        }
        if (o1 instanceof CoverageBeginning && hashCode1 > hashCode2) {
            return 1;
        }
        if (o1 instanceof CoverageEnd && hashCode1 < hashCode2) {
            return 1;
        }
        return -1;
    }
}

