/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.java;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.ElementInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.registry.CoverageDataRange;
import com.atlassian.clover.registry.entities.FullElementInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.util.Sets;

public class CoverageAnnotationFilter {
    public static final QualifiedName EXCLUDED_TEST_NAMES = new QualifiedName("org.openclover.eclipse.core", "CoverageAnnotationExcludedTestNames");
    public static CoverageAnnotationFilter NULL = new CoverageAnnotationFilter(){

        @Override
        public boolean includes(SourceInfo info) {
            return true;
        }
    };
    private CloverDatabase database;
    private Set<TestCaseInfo> includedTests;
    private TestFilter excludedTestNames;
    private boolean filterOutFullyCovered;
    private ContextSet blockFilter;
    private Map<TestCaseInfo, BitSet> tcisAndCoverageForFile;

    public static CoverageAnnotationFilter loadFor(CloverDatabase database, FullFileInfo fileInfo, Map<TestCaseInfo, BitSet> tcisAndHitsForFile, IResource editedResource, boolean hideCovered, ContextSet blockFilter) {
        return new CoverageAnnotationFilter(database, fileInfo, tcisAndHitsForFile, TestFilter.loadFor(editedResource, EXCLUDED_TEST_NAMES), hideCovered, blockFilter);
    }

    private CoverageAnnotationFilter() {
    }

    private CoverageAnnotationFilter(CloverDatabase database, FullFileInfo fileInfo, Map<TestCaseInfo, BitSet> tcisAndCoverageForFile, TestFilter testNames, boolean filterOutFullyCovered, ContextSet blockFilter) {
        this.database = database;
        this.excludedTestNames = testNames;
        this.blockFilter = blockFilter;
        this.filterOutFullyCovered = filterOutFullyCovered;
        this.tcisAndCoverageForFile = tcisAndCoverageForFile;
        HashSet<TestCaseInfo> includedTests = Sets.newHashSet(tcisAndCoverageForFile.keySet());
        Iterator iterator = includedTests.iterator();
        while (iterator.hasNext()) {
            TestCaseInfo testCase = (TestCaseInfo)iterator.next();
            if (testCase == null || !testCase.isResolved() && !testCase.resolve((FullProjectInfo)fileInfo.getContainingPackage().getContainingProject()) || !testNames.matches(testCase)) continue;
            iterator.remove();
        }
        this.includedTests = includedTests;
    }

    public boolean includes(SourceInfo info) {
        block4: {
            block5: {
                block3: {
                    block2: {
                        if (!(info instanceof BranchInfo)) break block2;
                        BranchInfo branchInfo = (BranchInfo)info;
                        if (!this.filterOutFullyCovered || branchInfo.getTrueHitCount() <= 0 || branchInfo.getFalseHitCount() <= 0) break block3;
                        break block4;
                    }
                    if (!(info instanceof ElementInfo)) break block3;
                    ElementInfo elementInfo = (ElementInfo)info;
                    if (this.filterOutFullyCovered && elementInfo.getHitCount() > 0) break block4;
                }
                if (!(info instanceof CoverageDataRange) || this.isPartiallyCoveredBranch(info)) break block5;
                Set<TestCaseInfo> hittingTcis = CoverageData.tcisInHitRange(this.tcisAndCoverageForFile, (CoverageDataRange)((Object)info));
                HashSet<TestCaseInfo> filteredHits = Sets.newHashSet(hittingTcis);
                filteredHits.retainAll(this.includedTests);
                if (filteredHits.size() == 0 && hittingTcis.size() > 0) break block4;
            }
            return true;
        }
        return false;
    }

    public boolean isHidden(SourceInfo info) {
        return info instanceof FullElementInfo && ((FullElementInfo)info).isFiltered(this.blockFilter);
    }

    private boolean isPartiallyCoveredBranch(SourceInfo info) {
        return info instanceof BranchInfo && (((BranchInfo)info).getTrueHitCount() == 0 || ((BranchInfo)info).getFalseHitCount() == 0);
    }

    public static class TestFilter {
        private Set<Integer> ids;
        private Set<String> testClassNames;

        public TestFilter() {
            this(new HashSet<Integer>(), new HashSet<String>());
        }

        public TestFilter(Set<Integer> ids, Set<String> testClassNames) {
            this.ids = ids;
            this.testClassNames = testClassNames;
        }

        public void addTestCase(TestCaseInfo test) {
            this.ids.add(test.getId());
        }

        public void removeTestCase(TestCaseInfo test) {
            this.ids.remove(test.getId());
        }

        public void addTestClass(ClassInfo clazz) {
            this.testClassNames.add(clazz.getQualifiedName());
        }

        public void removeTestClass(ClassInfo clazz) {
            this.testClassNames.remove(clazz.getQualifiedName());
        }

        public static TestFilter loadFor(IResource editedResource, QualifiedName propertyName) {
            HashSet<Integer> testIds = Sets.newHashSet();
            HashSet<String> testClasses = Sets.newHashSet();
            if (editedResource != null) {
                try {
                    String testIdsAsString = (String)editedResource.getSessionProperty(propertyName);
                    if (testIdsAsString != null) {
                        String[] testIdStrings;
                        for (String testIdString : testIdStrings = testIdsAsString.split(",")) {
                            try {
                                testIds.add(Integer.valueOf(testIdString));
                            }
                            catch (NumberFormatException e) {
                                testClasses.add(testIdString);
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    CloverPlugin.logError("Unable to query filtered out test ids/classes for " + editedResource, e);
                }
            }
            return new TestFilter(testIds, testClasses);
        }

        public void saveFor(IResource editedResource, QualifiedName propertyName) {
            try {
                StringBuilder value = new StringBuilder();
                Iterator<Object> iterator = this.ids.iterator();
                while (iterator.hasNext()) {
                    value.append(iterator.next());
                    if (!iterator.hasNext() && this.testClassNames.size() <= 0) continue;
                    value.append(',');
                }
                iterator = this.testClassNames.iterator();
                while (iterator.hasNext()) {
                    value.append((String)iterator.next());
                    if (!iterator.hasNext()) continue;
                    value.append(',');
                }
                editedResource.setSessionProperty(propertyName, (Object)value.toString());
            }
            catch (CoreException e) {
                CloverPlugin.logError("Unable to save test ids/classes for " + editedResource, e);
            }
        }

        public static void removeFor(IResource resource, QualifiedName name) {
            try {
                resource.setSessionProperty(name, null);
            }
            catch (CoreException e) {
                CloverPlugin.logError("Unable to remove test names for " + resource, e);
            }
        }

        public boolean matches(TestCaseInfo testCaseInfo) {
            return testCaseInfo.getRuntimeType() != null && this.testClassNames.contains(testCaseInfo.getRuntimeType().getQualifiedName()) || this.ids.contains(testCaseInfo.getId());
        }

        public boolean isEmpty() {
            return this.testClassNames.isEmpty() && this.ids.isEmpty();
        }
    }
}

