/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.cloud;

import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.BlockMetrics;
import com.atlassian.clover.registry.metrics.HasMetricsSupport;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.ui.editors.CloverProjectInput;
import org.openclover.eclipse.core.ui.editors.cloud.CloudProjectInput;
import org.openclover.eclipse.core.ui.editors.cloud.EclipseCloudGenerator;
import org.openclover.eclipse.core.ui.editors.cloud.EditorLinkingLocationListener;
import org.openclover.eclipse.core.ui.editors.cloud.RefreshCloudEditorGenerateCloudJob;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeEvent;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeListener;
import org.openclover.eclipse.core.views.actions.OpenJavaEditorAction;

public class CloudEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    public static final String ID = "org.openclover.eclipse.core.editors.cloud";
    private static final int QUICK_WINS_PAGE = 1;
    private static final int PROJECT_RISKS_PAGE = 0;
    private Map<String, PackageCloudStructure> perPackageCloudMappings;
    private Browser[] browsers = new Browser[2];
    private LocationListener locationListener = EditorLinkingLocationListener.NO_LINKING;
    private OpenJavaEditorAction openAction;
    private Combo focusDropDown;
    private Button aggregateCheckbox;
    private Button refreshButton;
    private DatabaseChangeListener coverageListener = new DatabaseChangeListener(){

        @Override
        public void databaseChanged(DatabaseChangeEvent event) {
            if (event.isApplicableTo(((CloverProjectInput)CloudEditor.this.getEditorInput()).getProject()) && event.isSubstantiveProjectChange()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CloudEditor.this.onCoverageChanged();
                    }
                });
            }
        }
    };

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        if (!(editorInput instanceof CloudProjectInput)) {
            throw new PartInitException("Invalid Input: must be CloudInput");
        }
        this.openAction = new OpenJavaEditorAction((IWorkbenchSite)this.getSite().getPage().getActivePart().getSite());
        this.locationListener = new EditorLinkingLocationListener(((CloverProjectInput)editorInput).getProject(), this.openAction);
    }

    private void createProjectRisksPage() {
        this.browsers[0] = new Browser(this.getContainer(), 0);
        this.browsers[0].setUrl(this.getProjectRisksURI());
        this.browsers[0].addLocationListener(this.locationListener);
        this.setPageText(this.addPage((Control)this.browsers[0]), CloverEclipsePluginMessages.PROJECT_RISKS());
    }

    private void createQuickWinsPage() {
        this.browsers[1] = new Browser(this.getContainer(), 0);
        this.browsers[1].setUrl(this.getProjectQuickWinsURI());
        this.browsers[1].addLocationListener(this.locationListener);
        this.setPageText(this.addPage((Control)this.browsers[1]), CloverEclipsePluginMessages.QUICK_WINS());
    }

    protected void createPages() {
        this.updatePerPackageCloudMapping();
        this.createProjectRisksPage();
        this.createQuickWinsPage();
        this.getContainer().getParent().setLayout((Layout)new GridLayout(1, false));
        this.getContainer().setLayoutData((Object)new GridData(1808));
        Composite bottomBar = new Composite(this.getContainer().getParent(), 0);
        bottomBar.setLayout((Layout)new GridLayout());
        Composite selectionBar = new Composite(bottomBar, 0);
        selectionBar.setLayout((Layout)new GridLayout(2, false));
        this.createFocusDropDown(selectionBar);
        this.createAggregateCheckbox(selectionBar);
        this.createRefreshButton(bottomBar);
        this.populateFocusDropDown();
        CloverPlugin.getInstance().getCoverageMonitor().addCoverageChangeListener(this.coverageListener);
    }

    private void createAggregateCheckbox(Composite selectionBar) {
        this.aggregateCheckbox = new Button(selectionBar, 32);
        this.aggregateCheckbox.setText(CloverEclipsePluginMessages.SHOW_AGGREGATE_CLOUD());
        this.aggregateCheckbox.setSelection(true);
        this.aggregateCheckbox.setEnabled(false);
        this.aggregateCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CloudEditor.this.refresh(false);
            }
        });
    }

    private void createFocusDropDown(Composite selectionBar) {
        this.focusDropDown = new Combo(selectionBar, 2060);
        this.focusDropDown.setLayoutData((Object)new GridData(32));
        this.focusDropDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CloudEditor.this.refresh(false);
            }
        });
    }

    private void updatePerPackageCloudMapping() {
        LinkedHashMap<String, PackageCloudStructure> perPackageCloudMappings = new LinkedHashMap<String, PackageCloudStructure>();
        FullProjectInfo project = ((CloudProjectInput)this.getEditorInput()).getProject().getModel().getAppOnlyProjectInfo();
        File outputDir = this.getReportBaseFolder();
        this.addCloudMap(perPackageCloudMappings, this.getProjectCloudName(), outputDir, false);
        List<? extends PackageInfo> packages = project.getAllPackages();
        Collections.sort(packages, HasMetricsSupport.CMP_LEX);
        for (PackageInfo packageInfo : packages) {
            this.addCloudMap(perPackageCloudMappings, packageInfo.getName(), new File(outputDir, packageInfo.getPath()), packageInfo.getClasses().size() < packageInfo.getClassesIncludingSubPackages().size());
        }
        this.perPackageCloudMappings = perPackageCloudMappings;
    }

    private void addCloudMap(Map<String, PackageCloudStructure> pageMaps, String name, File outputDir, boolean hasDescendantClasses) {
        pageMaps.put(name, new PackageCloudStructure(name, outputDir, hasDescendantClasses));
    }

    private void populateFocusDropDown() {
        String oldSelection = this.focusDropDown.getText();
        this.focusDropDown.clearSelection();
        this.focusDropDown.removeAll();
        for (PackageCloudStructure cloud : this.perPackageCloudMappings.values()) {
            this.focusDropDown.add(cloud.name);
        }
        if (oldSelection != null && oldSelection.length() > 0) {
            this.focusDropDown.setText(oldSelection);
        } else {
            this.focusDropDown.select(0);
        }
    }

    private void createRefreshButton(Composite bottomBar) {
        this.refreshButton = new Button(bottomBar, 0);
        this.refreshButton.setImage(CloverPlugin.getImage("icons/clcl16/project_refresh.gif"));
        this.refreshButton.setText(CloverEclipsePluginMessages.REFRESH_CLOUD_BUTTON());
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                new RefreshCloudEditorGenerateCloudJob(CloudEditor.this, ((CloverProjectInput)CloudEditor.this.getEditorInput()).getProject().getProject()).schedule();
            }
        });
    }

    private String getProjectCloudName() {
        return "Project " + ((CloudProjectInput)this.getEditorInput()).getProject().getModel().getAppOnlyProjectInfo().getName();
    }

    private File getReportBaseFolder() {
        return this.getReportDir().getRawLocation().toFile();
    }

    private String getProjectRisksURI() {
        return EclipseCloudGenerator.getRisksURIFor(this.getReportBaseFolder(), true);
    }

    public String getProjectQuickWinsURI() {
        return EclipseCloudGenerator.getQuickWinsURIFor(this.getReportBaseFolder(), true);
    }

    private void onCoverageChanged() {
        BlockMetrics metrics = MetricsScope.FULL.getMetricsFor(((CloverProjectInput)this.getEditorInput()).getProject().getProject());
        boolean coverageAvailable = metrics != null;
        this.refreshButton.setEnabled(coverageAvailable);
    }

    public void dispose() {
        super.dispose();
        CloverPlugin.getInstance().getCoverageMonitor().removeCoverageChangeListener(this.coverageListener);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    private IFolder getReportDir() {
        return ((CloverProjectInput)this.getEditorInput()).getProject().getCloverWorkingDir().getFolder("report");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
    }

    public void refresh(final boolean regenerate) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (regenerate) {
                    CloudEditor.this.updatePerPackageCloudMapping();
                    CloudEditor.this.populateFocusDropDown();
                }
                String selectedCloud = CloudEditor.this.focusDropDown.getText();
                PackageCloudStructure page = (PackageCloudStructure)CloudEditor.this.perPackageCloudMappings.get(selectedCloud);
                if (page != null) {
                    CloudEditor.this.aggregateCheckbox.setEnabled(page.hasSubpackages);
                    boolean showAggregateCloud = !page.hasSubpackages || CloudEditor.this.aggregateCheckbox.getSelection();
                    CloudEditor.this.browsers[0].setUrl(EclipseCloudGenerator.getRisksURIFor(page.outputDir, showAggregateCloud));
                    CloudEditor.this.browsers[1].setUrl(EclipseCloudGenerator.getQuickWinsURIFor(page.outputDir, showAggregateCloud));
                    CloudEditor.this.setPageText(0, page.name.equals(CloudEditor.this.getProjectCloudName()) ? CloverEclipsePluginMessages.PROJECT_RISKS() : CloverEclipsePluginMessages.PACKAGE_RISKS());
                }
            }
        });
    }

    private static final class PackageCloudStructure {
        public final String name;
        public final File outputDir;
        public final boolean hasSubpackages;

        PackageCloudStructure(String name, File outputDir, boolean hasSubpackages) {
            this.name = name;
            this.outputDir = outputDir;
            this.hasSubpackages = hasSubpackages;
        }
    }
}

