/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.settings;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.ui.SwtUtils;

public class RefreshFieldEditor
extends FieldEditor {
    private Button changeControl;
    private Combo refreshIntervalCombo;

    public RefreshFieldEditor(Composite parent) {
        super(RefreshFieldEditor.getCompositePreferenceName(), CloverEclipsePluginMessages.AUTO_REFRESH_COVERAGE_DATA(), parent);
        this.init(RefreshFieldEditor.getCompositePreferenceName(), CloverEclipsePluginMessages.AUTO_REFRESH_COVERAGE_DATA());
        this.createControl(parent);
    }

    private int getComboSelection(long refreshPeriod) {
        switch ((int)refreshPeriod) {
            case 2000: {
                return 0;
            }
            case 5000: {
                return 1;
            }
            case 10000: {
                return 2;
            }
            case 20000: {
                return 3;
            }
        }
        return this.getDefaultComboSelection();
    }

    private int getDefaultComboSelection() {
        return this.getComboSelection(2000L);
    }

    private long getPreferenceValueForComboSelection() {
        switch (this.refreshIntervalCombo.getSelectionIndex()) {
            case 0: {
                return 2000L;
            }
            case 1: {
                return 5000L;
            }
            case 2: {
                return 10000L;
            }
            case 3: {
                return 20000L;
            }
        }
        return 2000L;
    }

    protected void adjustForNumColumns(int numColumns) {
        SwtUtils.setHorizontalSpan((Control)this.refreshIntervalCombo, numColumns - 1);
    }

    protected void doLoad() {
        this.changeControl.setSelection(this.getPreferenceStore().getBoolean("auto_refresh_coverage_data"));
        this.refreshIntervalCombo.select(this.getComboSelection(this.getPreferenceStore().getLong("coverage_refresh")));
    }

    protected void doLoadDefault() {
        this.changeControl.setSelection(true);
        this.refreshIntervalCombo.select(this.getDefaultComboSelection());
    }

    protected void doStore() {
        this.getPreferenceStore().setValue("auto_refresh_coverage_data", this.changeControl.getSelection());
        this.getPreferenceStore().setValue("coverage_refresh", this.getPreferenceValueForComboSelection());
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        if (this.changeControl == null) {
            this.changeControl = new Button(parent, 32);
            this.changeControl.setLayoutData((Object)new GridData());
            this.changeControl.setText(this.getLabelText());
            this.refreshIntervalCombo = new Combo(parent, 8);
            this.refreshIntervalCombo.setItems(new String[]{CloverEclipsePluginMessages.TWO_SECONDS(), CloverEclipsePluginMessages.FIVE_SECONDS(), CloverEclipsePluginMessages.TEN_SECONDS(), CloverEclipsePluginMessages.TWENTY_SECONDS()});
            SwtUtils.setHorizontalSpan((Control)this.refreshIntervalCombo, numColumns - 1);
        } else {
            this.checkParent((Control)this.changeControl, parent);
            this.checkParent((Control)this.refreshIntervalCombo, parent);
        }
    }

    public static String getCompositePreferenceName() {
        return "composite[auto_refresh_coverage_data,coverage_refresh]";
    }
}

