/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.settings;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.Interval;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.settings.Settings;
import org.openclover.eclipse.core.views.CustomColumnDefinition;
import org.openclover.util.Lists;

public class InstallationSettings
extends Settings {
    private List<CustomColumnDefinition> customColumns;

    public InstallationSettings() {
        this.isolatedPreferences = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("configuration").node("org.openclover.eclipse.core");
        this.load();
    }

    public void setDebugging(boolean debug) {
        this.setValue("logging_level", debug ? "debug" : "none");
    }

    public long getCoverageRefreshPeriod() {
        return this.getLong("coverage_refresh", 0L);
    }

    public boolean isAutoRefreshingCoverage() {
        return this.getBoolean("auto_refresh_coverage_data");
    }

    public void setAutoRefreshingCoverage(boolean autoRefresh) {
        this.setValue("auto_refresh_coverage_data", autoRefresh);
    }

    public String getLoggingLevel() {
        return this.getString("logging_level");
    }

    public boolean isDeletingCoverageOnRebuild() {
        return "clear".equals(this.getString("action_when_rebuilding"));
    }

    public boolean isPromptingOnRebuild() {
        return this.getBoolean("when_rebuilding_prompt_me");
    }

    public void setLatestPromptOnRebuildDecision(boolean coverageCleared) {
        this.setValue("action_when_rebuilding", coverageCleared ? "clear" : "leave");
    }

    public void setPromptingOnRebuild(boolean prompt) {
        this.setValue("when_rebuilding_prompt_me", prompt);
    }

    public Interval getCoverageSpan() {
        try {
            String spanDescription = this.getString("coverage_span");
            return new Interval(spanDescription == null ? "0s" : spanDescription);
        }
        catch (NumberFormatException e) {
            return new Interval("0s");
        }
    }

    public boolean isAggregatingCoverage() {
        return this.getBoolean("aggregate_coverage");
    }

    public void setAggregateCoverage(boolean aggregate) {
        this.setValue("aggregate_coverage", aggregate);
    }

    public boolean isTrackingPerTestCoverage() {
        return this.getBoolean("track_pertest_coverage");
    }

    public void setTrackingPerTestCoverage(boolean track) {
        this.setValue("track_pertest_coverage", track);
    }

    public boolean isPerTestCoverageInMemory() {
        return this.getBoolean("pertest_coverage_inmem");
    }

    public void setPerTestCoverageInMemory(boolean inMemory) {
        this.setValue("pertest_coverage_inmem", inMemory);
    }

    public long getCoverageSpanInMillis() {
        return this.getCoverageSpan().getValueInMillis();
    }

    public boolean isRebuildingOnContextChange() {
        return "rebuild".equals(this.getString("action_when_context_changes"));
    }

    public boolean isPromptingOnContextChange() {
        return this.getBoolean("when_context_changes_prompt_me");
    }

    public void setLatestPromptOnContextChange(boolean rebuild) {
        this.setValue("action_when_context_changes", rebuild ? "rebuild" : "ignore");
    }

    public void setPromptingOnContextChange(boolean prompt) {
        this.setValue("when_context_changes_prompt_me", prompt);
    }

    public boolean isRebuildingOnInstrumentationSourceChange() {
        return "rebuild".equals(this.getString("action_when_instrumentation_source_changes"));
    }

    public boolean isPromptingOnInstrumentationSourceChange() {
        return this.getBoolean("when_instrumentation_source_changes_prompt_me");
    }

    public void setLatestPromptOnInstrumentationSourceChange(boolean rebuild) {
        this.setValue("action_when_instrumentation_source_changes", rebuild ? "rebuild" : "ignore");
    }

    public void isPromptingOnInstrumentationSourceChange(boolean prompt) {
        this.setValue("when_instrumentation_source_changes_prompt_me", prompt);
    }

    public List<CustomColumnDefinition> getCustomColumns() {
        if (this.customColumns == null) {
            this.customColumns = this.loadCustomColumns();
        }
        return this.customColumns;
    }

    public void setCustomColumns(List<CustomColumnDefinition> columns) {
        this.setValue("custom.column.count", columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            CustomColumnDefinition columnDef = columns.get(i);
            this.setValue("custom.column." + i + ".name", columnDef.getTitle());
            this.setValue("custom.column." + i + ".name.abbreviated", columnDef.getAbbreviatedTitle());
            this.setValue("custom.column." + i + ".expression", columnDef.getExpression());
        }
        this.customColumns = columns;
    }

    private List<CustomColumnDefinition> loadCustomColumns() {
        LinkedList customColumns = Lists.newLinkedList();
        int customColCount = this.getInt("custom.column.count");
        if (customColCount > 0) {
            for (int i = 0; i < customColCount; ++i) {
                String title = this.getString("custom.column." + i + ".name");
                String abbreviatedTitle = this.getString("custom.column." + i + ".name.abbreviated");
                abbreviatedTitle = abbreviatedTitle == null ? title : abbreviatedTitle;
                String expression = this.getString("custom.column." + i + ".expression");
                int style = this.getInt("custom.column." + i + ".style");
                int format = this.getInt("custom.column." + i + ".format");
                try {
                    customColumns.add(new CustomColumnDefinition(title, abbreviatedTitle, expression, style, format));
                    continue;
                }
                catch (CloverException e) {
                    CloverPlugin.logError("Unable to define load custom column \"" + title + "\" : \"" + expression + "\" : \"" + e.getMessage() + "\" - ignoring", e);
                }
            }
        }
        return Collections.unmodifiableList(customColumns);
    }

    public int getEditorCoverageStyle() {
        return this.getInt("coverage_style_in_editors");
    }

    public void setEditorCoverageStyle(int style) {
        this.setValue("coverage_style_in_editors", style);
    }

    public long getInstallDate() {
        return this.getLong("install_date");
    }

    public void setInstallDate(long when) {
        this.setValue("install_date", when);
    }

    public boolean isShowExclusionAnnotations() {
        return this.getBoolean("show_exclusion_annotations");
    }

    public void setShowExclusionAnnotations(boolean show) {
        this.setValue("show_exclusion_annotations", show);
    }

    public boolean isIncludeFailedCoverage() {
        return this.getBoolean("include_failed_coverage");
    }

    public void setIncludeFailedCoverage(boolean include) {
        this.setValue("include_failed_coverage", include);
    }

    public boolean isPreserveInstrumentedSources() {
        return this.getBoolean("preserve_instrumented_sources");
    }

    public void setPreserveInstrumentedSources(boolean preserve) {
        this.setValue("preserve_instrumented_sources", preserve);
    }

    public boolean isAutoOpenCloverViews() {
        return this.getBoolean("auto_open_clover_views");
    }

    public void setAutoOpenCloverViews(boolean autoOpen) {
        this.setValue("auto_open_clover_views", autoOpen);
    }

    public static class Defaults {
        public static final long COVERAGE_REFRESH_PERIOD = 2000L;
        public static final boolean REFRESH_COVERAGE = true;
        public static final String ACTION_WHEN_REBUILDING = "clear";
        public static final boolean WHEN_REBUILDING_PROMPT_ME = true;
        public static final String ACTION_WHEN_CONTEXT_CHANGES = "ignore";
        public static final boolean WHEN_CONTEXT_CHANGE_PROMPT_ME = true;
        public static final String ACTION_WHEN_INSTRUMENTATION_SOURCE_CHANGES = "ignore";
        public static final boolean WHEN_INSTRUMENTATION_SOURCE_CHANGE_PROMPT_ME = true;
        public static final String COVERAGE_SPAN = "0s";
        public static final int SHOW_COVERAGE_IN_EDITORS = 0;
        public static final String LOGGING_LEVEL = "none";
        public static final boolean PRIME_AWT_IN_UI_THREAD = false;
        public static final boolean ALWAYS_FULL_BUILD = false;
        public static final boolean AGGREGATE_COVERAGE = true;
        public static final boolean TRACK_PERTEST_COVERAGE = true;
        public static final boolean PERTEST_COVERAGE_INMEM = false;
        public static final boolean SHOW_EXCLUSION_ANNOTATIONS = true;
        public static final boolean INCLUDE_FAILED_COVERAGE = false;
        public static final boolean PRESERVE_INSTRUMENTED_SOURCES = false;
        public static final boolean AUTO_OPEN_CLOVER_VIEWS = true;
    }

    public static class Values {
        public static final long TWO_SECONDS_COVERAGE_REFRESH_PERIOD = 2000L;
        public static final long FIVE_SECONDS_COVERAGE_REFRESH_PERIOD = 5000L;
        public static final long TEN_SECONDS_COVERAGE_REFRESH_PERIOD = 10000L;
        public static final long TWENTY_SECONDS_COVERAGE_REFRESH_PERIOD = 20000L;
        public static final String WHEN_REBUILDING_CLEAR_COVERAGE = "clear";
        public static final String WHEN_REBUILDING_LEAVE_COVERAGE = "leave";
        public static final String WHEN_CONTEXT_CHANGES_REBUILD = "rebuild";
        public static final String WHEN_CONTEXT_CHANGES_IGNORE = "ignore";
        public static final int SHOW_ALL_COVERAGE_IN_EDITORS = 0;
        public static final int SHOW_ONLY_UNCOVERED_IN_EDITORS = 1;
        public static final int SHOW_NO_COVERAGE_IN_EDITORS = 2;
        public static final String NO_LOGGING_LEVEL = "none";
        public static final String DEBUG_LOGGING_LEVEL = "debug";
        public static final String VERBOSE_LOGGING_LEVEL = "verbose";
        public static final String INFO_LOGGING_LEVEL = "info";
    }

    public static class Keys {
        public static final String COVERAGE_REFRESH_PERIOD = "coverage_refresh";
        public static final String ACTION_WHEN_REBUILDING = "action_when_rebuilding";
        public static final String WHEN_REBUILDING_PROMPT_ME = "when_rebuilding_prompt_me";
        public static final String ACTION_WHEN_CONTEXT_CHANGES = "action_when_context_changes";
        public static final String WHEN_CONTEXT_CHANGES_PROMPT_ME = "when_context_changes_prompt_me";
        public static final String ACTION_WHEN_INSTRUMENTATION_SOURCE_CHANGES = "action_when_instrumentation_source_changes";
        public static final String WHEN_INSTRUMENTATION_SOURCE_CHANGES_PROMPT_ME = "when_instrumentation_source_changes_prompt_me";
        public static final String AUTO_REFRESH_COVERAGE_DATA = "auto_refresh_coverage_data";
        public static final String COVERAGE_SPAN = "coverage_span";
        public static final String COVERAGE_STYLE_IN_EDITORS = "coverage_style_in_editors";
        public static final String WORKING_SET_ENABLED = "working_set_enabled";
        public static final String LOGGING_LEVEL = "logging_level";
        public static final String INSTALL_DATE = "install_date";
        public static final String PRIME_AWT_IN_UI_THREAD = "prime_awt_in_ui_thread";
        public static final String CUSTOM_COL_PREFIX = "custom.column.";
        public static final String CUSTOM_NAME_SUFFIX = ".name";
        public static final String CUSTOM_ABBREVIATED_NAME_SUFFIX = ".name.abbreviated";
        public static final String CUSTOM_EXPR_SUFFIX = ".expression";
        public static final String CUSTOM_STYLE_SUFFIX = ".style";
        public static final String CUSTOM_FORMAT_SUFFIX = ".format";
        public static final String CUSTOM_COL_COUNT = "custom.column.count";
        public static final String AGGREGATE_COVERAGE = "aggregate_coverage";
        public static final String TRACK_PERTEST_COVERAGE = "track_pertest_coverage";
        public static final String PERTEST_COVERAGE_INMEM = "pertest_coverage_inmem";
        public static final String SHOW_EXCLUSION_ANNOTATIONS = "show_exclusion_annotations";
        public static final String INCLUDE_FAILED_COVERAGE = "include_failed_coverage";
        public static final String PRESERVE_INSTRUMENTED_SOURCES = "preserve_instrumented_sources";
        public static final String AUTO_OPEN_CLOVER_VIEWS = "auto_open_clover_views";
    }
}

