/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.CloveredProjectLabelProvider;
import org.openclover.eclipse.core.reports.GenerateReportWizard;
import org.openclover.util.Lists;

public class SelectProjectsPage
extends WizardPage {
    private Table projectsTable;
    private TableViewer projectsTableViewer;
    private CloverProject initialProject;
    private CloverProject[] selectedProjects = new CloverProject[0];

    public SelectProjectsPage(CloverProject project) {
        super("SelectProjects");
        this.initialProject = project;
        this.setTitle("Project Selection");
        this.setDescription("Select one or more projects to report on.");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        new Label(composite, 0).setText("Clover-enabled projects:");
        this.projectsTable = new Table(composite, 2080);
        this.projectsTable.setLayoutData((Object)new GridData(1040));
        this.projectsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectProjectsPage.this.calcSelectedProjects();
                SelectProjectsPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.projectsTableViewer = new TableViewer(this.projectsTable);
        this.projectsTableViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object parent) {
                if (parent instanceof IProject) {
                    return null;
                }
                if (parent instanceof IWorkspace) {
                    ArrayList<IProject> projects = Lists.newArrayList(((IWorkspace)parent).getRoot().getProjects());
                    Iterator iter = projects.iterator();
                    while (iter.hasNext()) {
                        try {
                            if (CloverProject.isAppliedTo((IProject)iter.next())) continue;
                            iter.remove();
                        }
                        catch (CoreException e) {
                            iter.remove();
                        }
                    }
                    return projects.toArray();
                }
                return super.getChildren(parent);
            }
        });
        this.projectsTableViewer.setLabelProvider((IBaseLabelProvider)new CloveredProjectLabelProvider());
        this.projectsTableViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        if (this.initialProject != null) {
            TableItem[] items;
            for (TableItem item : items = this.projectsTable.getItems()) {
                if (item.getData() != this.initialProject.getProject()) continue;
                item.setChecked(true);
                this.selectedProjects = new CloverProject[]{this.initialProject};
                break;
            }
        }
        this.setControl((Control)composite);
    }

    private void calcSelectedProjects() {
        TableItem[] items = this.projectsTable.getItems();
        ArrayList<CloverProject> projects = new ArrayList<CloverProject>(items.length);
        for (TableItem item : items) {
            if (!item.getChecked()) continue;
            try {
                projects.add(CloverProject.getFor((IProject)item.getData()));
            }
            catch (CoreException e) {
                CloverPlugin.logError("Unable to coerce project into Clover project", e);
            }
        }
        this.selectedProjects = projects.toArray(new CloverProject[projects.size()]);
    }

    public boolean canFlipToNextPage() {
        TableItem[] items;
        boolean oneSelected = false;
        for (TableItem item : items = this.projectsTable.getItems()) {
            if (oneSelected |= item.getChecked()) break;
        }
        return oneSelected;
    }

    public IWizardPage getNextPage() {
        GenerateReportWizard wizard = (GenerateReportWizard)this.getWizard();
        if (wizard.selectReportPage.isHtmlSelected()) {
            return wizard.configureHtmlPage;
        }
        if (wizard.selectReportPage.isPdfSelected()) {
            return wizard.configurePdfPage;
        }
        if (wizard.selectReportPage.isXmlSelected()) {
            return wizard.configureXmlPage;
        }
        return null;
    }

    public CloverProject[] getSelectedProjects() {
        return this.selectedProjects;
    }
}

