/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CloverDatabaseSpec;
import com.atlassian.clover.ProgressListener;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.reporters.CloverReporter;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.html.HtmlReporter;
import com.atlassian.clover.reporters.pdf.PDFReporter;
import com.atlassian.clover.reporters.xml.XMLReporter;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.reports.ForkingReportJob;
import org.openclover.eclipse.core.reports.ForkingReporter;
import org.openclover.util.Lists;

public class MergeReportJob
extends ForkingReportJob {
    private final CloverProject[] projects;

    public MergeReportJob(CloverProject[] projects, Current reportConfig, String vmArgs, String mxSetting) {
        super(reportConfig, vmArgs, mxSetting);
        this.projects = projects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IStatus runReporter(final IProgressMonitor monitor) throws Exception {
        final RuntimeException cancelled = new RuntimeException();
        CloverDatabaseSpec[] specs = new CloverDatabaseSpec[this.projects.length];
        monitor.beginTask("Generating report", 100);
        try {
            for (int i = 0; i < this.projects.length; ++i) {
                specs[i] = new CloverDatabaseSpec(this.projects[i].deriveInitString());
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
            subMonitor.beginTask("Merging Clover databases", 100);
            try {
                CloverDatabase.merge(Lists.newArrayList(specs), this.config.getInitString(), new ProgressListener(){
                    private int lastWorked;

                    @Override
                    public void handleProgress(String desc, float pc) {
                        if (monitor.isCanceled()) {
                            throw cancelled;
                        }
                        monitor.worked((int)(100.0f * pc) - this.lastWorked);
                        this.lastWorked = (int)(100.0f * pc);
                    }
                });
            }
            finally {
                subMonitor.done();
            }
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
            subMonitor.beginTask("Generating report", 100);
            try {
                CloverReporter.buildReporter(this.config).execute();
            }
            finally {
                subMonitor.done();
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            if (e == cancelled) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            Status status = new Status(4, "org.openclover.eclipse.core", 0, "Clover failed to merge the multiple Clover databases prior to report generation", (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected String calculateReporterClass() {
        switch (this.config.getFormat().getType()) {
            case HTML: {
                return MergeAndReportHtml.class.getName();
            }
            case PDF: {
                return MergeAndReportPdf.class.getName();
            }
        }
        return MergeAndReportXml.class.getName();
    }

    @Override
    protected String calcTestFilterArgs() {
        return this.calcTestFilterArgs(this.projects);
    }

    @Override
    protected String calculateProgramArgs() {
        StringBuilder buf = new StringBuilder();
        for (CloverProject project : this.projects) {
            buf.append(MergeReportJob.quote(project.deriveInitString()));
            buf.append(" ");
            buf.append(MergeReportJob.quote(project.getSettings().calcEffectiveSpanInterval(project.getModel().getDatabase()).toString()));
            buf.append(" ");
        }
        buf.append("--report ");
        buf.append(super.calculateProgramArgs());
        return buf.toString();
    }

    public static class MergeAndReportXml
    extends MergeAndReport {
        @Override
        protected int postMergeRun(String[] args) {
            return XMLReporter.runReport(args);
        }
    }

    public static class MergeAndReportPdf
    extends MergeAndReport {
        @Override
        protected int postMergeRun(String[] args) {
            return PDFReporter.runReport(args);
        }
    }

    public static class MergeAndReportHtml
    extends MergeAndReport {
        @Override
        protected int postMergeRun(String[] args) {
            return HtmlReporter.runReport(args);
        }
    }

    public static abstract class MergeAndReport
    extends ForkingReporter {
        private String filterClassName;

        @Override
        protected final int run(String[] args) {
            try {
                String mergedInitFile = null;
                ArrayList<String> initStringsAndSpans = new ArrayList<String>(args.length);
                ArrayList reportArgs = new ArrayList(args.length);
                ArrayList<String> bucket = initStringsAndSpans;
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("--report")) {
                        bucket = reportArgs;
                        continue;
                    }
                    if ("-i".equals(args[i])) {
                        mergedInitFile = args[i + 1];
                    }
                    bucket.add(args[i]);
                }
                System.out.println(initStringsAndSpans);
                CloverDatabaseSpec[] specs = new CloverDatabaseSpec[initStringsAndSpans.size() / 2];
                for (int i = 0; i < initStringsAndSpans.size(); i += 2) {
                    specs[i / 2] = new CloverDatabaseSpec((String)initStringsAndSpans.get(i));
                    specs[i / 2].setSpan(new Interval((String)initStringsAndSpans.get(i + 1)));
                }
                CloverDatabase.merge(Lists.newArrayList(specs), mergedInitFile, ProgressListener.NOOP_LISTENER);
                return this.postMergeRun(reportArgs.toArray(new String[reportArgs.size()]));
            }
            catch (Throwable t) {
                System.out.println("Error generating report: " + t);
                t.printStackTrace(System.out);
                return 1;
            }
        }

        protected abstract int postMergeRun(String[] var1);
    }
}

