/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.openclover.eclipse.core.ui.SwtUtils;

public class ConfigureJvmPage
extends WizardPage {
    private static final String[] VM_SIZES = new String[]{"256m", "512m", "768m", "1024m", "2048m"};
    private static final String[] VM_SIZE_NAMES = new String[]{"256 MB", "512 MB", "768 MB", "1024 MB", "2048 MB"};
    private Text jvmArgsText;
    private Combo jvmMaxHeapCombo;

    public ConfigureJvmPage() {
        super("ConfigureJvm");
        this.setTitle("Report JVM Configuration");
        this.setDescription("Fine-tune the Java Virtual Machine used for reporting, if required.");
    }

    public void createControl(Composite parent) {
        Composite settings = new Composite(parent, 0);
        settings.setLayout((Layout)new GridLayout(2, false));
        SwtUtils.gridDataFor((Control)settings).horizontalSpan = 2;
        Label heapLabel = new Label(settings, 0);
        heapLabel.setText("Maximum heap size:");
        heapLabel.setToolTipText("Sets the maximum memory heap size for the created Java Virtual Machine. Increasing this for medium to large projects or where you are reporting on more than one project at a time may speed up the time taken for reporting.");
        this.jvmMaxHeapCombo = new Combo(settings, 8);
        this.jvmMaxHeapCombo.setItems(VM_SIZE_NAMES);
        this.jvmMaxHeapCombo.select(1);
        Label argLabel = new Label(settings, 0);
        argLabel.setText("Additional JVM arguments:");
        argLabel.setToolTipText("Supplies additional arguments to the the created Java Virtual Machine. ");
        this.jvmArgsText = new Text(settings, 2048);
        this.jvmArgsText.setLayoutData((Object)new GridData(768));
        this.setControl((Control)settings);
    }

    public String getJvmArgs() {
        return this.jvmArgsText.getText();
    }

    public String getMaxHeapSize() {
        return VM_SIZES[this.jvmMaxHeapCombo.getSelectionIndex()];
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        return true;
    }
}

