/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.reports;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.openclover.eclipse.core.reports.ConfigureReportPage;
import org.openclover.eclipse.core.reports.GenerateReportWizard;
import org.openclover.eclipse.core.ui.SwtUtils;

public class ConfigureHtmlPage
extends ConfigureReportPage {
    private Button srcButton;

    public ConfigureHtmlPage() {
        super("ConfigureHTML");
        this.setTitle("HTML Report Configuration");
        this.setDescription("Fine tune the available coverage report options.");
    }

    @Override
    protected String getDefaultOutputPathFor(IProject project) {
        return project.getFolder("report").getFolder("html").getLocation().toFile().getAbsolutePath();
    }

    @Override
    protected Listener newOutputPathListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((GenerateReportWizard)ConfigureHtmlPage.this.getWizard()).workbench.getActiveWorkbenchWindow().getShell();
                DirectoryDialog chooser = new DirectoryDialog(shell, 32768);
                chooser.setText("Choose a directory");
                chooser.setFilterPath(ConfigureHtmlPage.this.outputPath.getText());
                String result = chooser.open();
                if (result != null) {
                    ConfigureHtmlPage.this.setOutputPath(result);
                }
            }
        };
    }

    @Override
    protected String getOutputPathLabelTitle() {
        return "Output Directory:";
    }

    @Override
    protected void createCustomSettings(Composite composite) {
        this.srcButton = new Button(composite, 32);
        this.srcButton.setText("Include source");
        this.srcButton.setSelection(true);
        GridData gd = SwtUtils.gridDataFor((Control)this.srcButton);
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 1;
        this.createShowLambdaComposite(composite);
    }

    @Override
    protected void addListeners() {
        Listener listener = this.newValidationListener();
        this.outputPath.addListener(2, listener);
        this.fileButton.addListener(13, listener);
        this.threadCount.addListener(13, listener);
    }

    protected boolean shouldIncludeSource() {
        return this.srcButton.getSelection();
    }
}

