/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.settings.source.test;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.instr.tests.DefaultTestDetector;
import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.instr.tests.TestSourceMatcher;
import com.atlassian.clover.spec.instr.test.BooleanSpec;
import java.io.File;
import java.util.Collections;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.settings.source.test.ExpressionElement;
import org.openclover.eclipse.core.projects.settings.source.test.OrExpressionElement;
import org.openclover.eclipse.core.projects.settings.source.test.SourceExcludePatternElement;
import org.openclover.eclipse.core.projects.settings.source.test.SourceIncludePatternElement;
import org.openclover.eclipse.core.projects.settings.source.test.SourcePatternElement;
import org.openclover.eclipse.core.projects.settings.source.test.TestSourcesElement;
import org.openclover.eclipse.core.projects.settings.source.test.TreeElement;

public class TestPackageRootElement
implements TreeElement {
    private TestSourcesElement parent;
    private IPath projectRelativePath;
    private SourcePatternElement includes = new SourceIncludePatternElement(this, "**/*.java");
    private SourcePatternElement excludes = new SourceExcludePatternElement(this);
    private ExpressionElement expression = new OrExpressionElement(this);

    public TestPackageRootElement(TestSourcesElement parent, String projectRelativePath) {
        this.parent = parent;
        this.projectRelativePath = new Path(projectRelativePath);
    }

    public void setProjectRelativePath(String projectRelativePath) {
        this.projectRelativePath = new Path(projectRelativePath);
    }

    public void setIncludes(SourcePatternElement includes) {
        this.includes = includes;
    }

    public void setExcludes(SourcePatternElement excludes) {
        this.excludes = excludes;
    }

    public SourcePatternElement getIncludes() {
        return this.includes;
    }

    public SourcePatternElement getExcludes() {
        return this.excludes;
    }

    public IPath getProjectRelativePath() {
        return this.projectRelativePath;
    }

    public ExpressionElement getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionElement expression) {
        this.expression = expression;
    }

    public TestSourceMatcher getTestSourceMatcher() {
        return new TestSourceMatcher(){

            @Override
            public boolean matchesFile(File f) {
                return false;
            }

            @Override
            public TestDetector getDetector() {
                try {
                    return BooleanSpec.buildTestDetectorFor(Collections.singletonList(TestPackageRootElement.this.expression.getSpec()));
                }
                catch (CloverException e) {
                    CloverPlugin.logError("Unable to build test detector", e);
                    return new DefaultTestDetector();
                }
            }
        };
    }

    @Override
    public TreeElement getParent() {
        return this.parent;
    }
}

