/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.settings.source.test;

import com.atlassian.clover.spec.instr.test.TestMethodSpec;
import java.util.ArrayList;
import java.util.List;
import org.openclover.eclipse.core.projects.settings.source.test.AnnotationNameConditionElement;
import org.openclover.eclipse.core.projects.settings.source.test.ConditionElement;
import org.openclover.eclipse.core.projects.settings.source.test.NameConditionElement;
import org.openclover.eclipse.core.projects.settings.source.test.SpecificConditionElement;
import org.openclover.eclipse.core.projects.settings.source.test.TestMethodsElement;
import org.openclover.eclipse.core.projects.settings.source.test.TreeElement;
import org.openclover.util.Lists;

public class TestMethodElement
implements TreeElement {
    private TestMethodsElement parent;
    private String annotation;
    private String name;
    private String returnType;

    public TestMethodElement(TestMethodsElement parent) {
        this.parent = parent;
    }

    public TestMethodElement(TestMethodsElement parent, String name, String annotation, String returnType) {
        this(parent);
        this.name = name;
        this.annotation = annotation;
        this.returnType = returnType;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public TestMethodSpec toTestMethodSpec() {
        TestMethodSpec testMethodSpec = new TestMethodSpec();
        testMethodSpec.setAnnotation(this.annotation);
        testMethodSpec.setName(this.name);
        testMethodSpec.setReturnType(this.returnType);
        return testMethodSpec;
    }

    @Override
    public TreeElement getParent() {
        return this.parent;
    }

    public List<ConditionElement> getConditions() {
        ArrayList<ConditionElement> result = Lists.newArrayList();
        if (this.name != null) {
            result.add(new NameConditionElement(this, this.name));
        }
        if (this.annotation != null) {
            result.add(new AnnotationNameConditionElement(this, this.annotation));
        }
        if (this.returnType != null) {
            result.add(new ReturnTypeNameConditionElement(this, this.returnType));
        }
        if (result.isEmpty()) {
            result.add(new AnyConditionElement(this));
        }
        return result;
    }

    public class AnyConditionElement
    extends org.openclover.eclipse.core.projects.settings.source.test.AnyConditionElement {
        public AnyConditionElement(TreeElement parent) {
            super(parent);
        }
    }

    public class ReturnTypeNameConditionElement
    extends SpecificConditionElement {
        public ReturnTypeNameConditionElement(TestMethodElement parent, String value) {
            super(parent, value);
        }
    }
}

