/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.settings.source.test;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.projects.settings.source.test.AnnotationNameConditionElement;
import org.openclover.eclipse.core.projects.settings.source.test.ExpressionElement;
import org.openclover.eclipse.core.projects.settings.source.test.NameConditionElement;
import org.openclover.eclipse.core.projects.settings.source.test.OrExpressionElement;
import org.openclover.eclipse.core.projects.settings.source.test.SourceExcludePatternElement;
import org.openclover.eclipse.core.projects.settings.source.test.SourceIncludePatternElement;
import org.openclover.eclipse.core.projects.settings.source.test.TestClassElement;
import org.openclover.eclipse.core.projects.settings.source.test.TestMethodElement;
import org.openclover.eclipse.core.projects.settings.source.test.TestMethodsElement;
import org.openclover.eclipse.core.projects.settings.source.test.TestPackageRootDialog;
import org.openclover.eclipse.core.projects.settings.source.test.TestPackageRootElement;
import org.openclover.eclipse.core.projects.settings.source.test.TestSourcesElement;
import org.openclover.eclipse.core.projects.settings.source.test.TreeElement;
import org.openclover.util.Lists;

public class TestFilesFilterWidget
extends Composite {
    private Tree sourceDirsTree;
    private TreeViewer sourceDirsTreeViewer;
    private Composite filterGroup;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private TestSourcesElement testPackageRoots;

    public TestFilesFilterWidget(ProjectSettings properties, Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        this.testPackageRoots = this.getTestPackageRoots(properties);
        this.sourceDirsTree = new Tree((Composite)this, 2048);
        this.sourceDirsTree.setLayoutData((Object)new GridData(1808));
        this.sourceDirsTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        this.sourceDirsTreeViewer = new TreeViewer(this.sourceDirsTree);
        this.sourceDirsTreeViewer.setAutoExpandLevel(4);
        this.sourceDirsTreeViewer.setContentProvider((IContentProvider)new TestPackageRootContentProvider());
        this.sourceDirsTreeViewer.setLabelProvider((IBaseLabelProvider)new TestPackageRootLabelProvider());
        this.sourceDirsTreeViewer.setInput((Object)this.testPackageRoots);
        this.filterGroup = new Composite((Composite)this, 0);
        this.filterGroup.setLayoutData((Object)new GridData(1040));
        this.filterGroup.setLayout((Layout)new GridLayout(1, true));
        this.addButton = new Button(this.filterGroup, 0);
        this.addButton.setText("Add Folder");
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TestFilesFilterWidget.this.addTestSourceFolder();
            }
        });
        this.editButton = new Button(this.filterGroup, 0);
        this.editButton.setText("Edit Folder");
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TestFilesFilterWidget.this.editSelectedTestSourceFolder();
            }
        });
        this.removeButton = new Button(this.filterGroup, 0);
        this.removeButton.setText("Remove Folder");
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TestFilesFilterWidget.this.removeSelectedTestSourceFolder();
            }
        });
    }

    private void addTestSourceFolder() {
        TestPackageRootDialog dialog = new TestPackageRootDialog(this.getShell());
        dialog.open();
    }

    private void removeSelectedTestSourceFolder() {
    }

    private void editSelectedTestSourceFolder() {
    }

    private TestSourcesElement getTestPackageRoots(ProjectSettings properties) {
        TestSourcesElement testPackageRoots = new TestSourcesElement();
        TestPackageRootElement testPackageRoot = testPackageRoots.newTestPackageRoot("foo/bar");
        TestClassElement testClass = testPackageRoot.getExpression().newTestClassElement();
        testClass.setName("Foo");
        testClass.setPackage("com\\.foo\\.bar");
        testClass.setAnnotation("Test");
        testClass.setSuper("TestCase");
        testClass.getTestMethods().newTestMethod(null, "FooAnno", null);
        testClass.getTestMethods().newTestMethod("Bar", null, null);
        testClass = testPackageRoot.getExpression().newTestClassElement();
        testClass.getTestMethods().newTestMethod(null, null, null);
        return testPackageRoots;
    }

    private void setTestPackageRoots(ProjectSettings properties) {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.sourceDirsTree.setEnabled(enabled);
        this.filterGroup.setEnabled(enabled);
    }

    public class TestPackageRootLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int col) {
            return null;
        }

        public String getColumnText(Object object, int col) {
            if (object instanceof TestPackageRootElement) {
                return "Examine source files in \"" + ((TestPackageRootElement)object).getProjectRelativePath() + "\"";
            }
            if (object instanceof SourceExcludePatternElement) {
                SourceExcludePatternElement sourceExcludePattern = (SourceExcludePatternElement)object;
                return "Excluded files: (" + (sourceExcludePattern.isEmpty() ? "None" : (sourceExcludePattern.isAll() ? "All" : sourceExcludePattern.getPattern())) + ")";
            }
            if (object instanceof SourceIncludePatternElement) {
                SourceIncludePatternElement sourceIncludePattern = (SourceIncludePatternElement)object;
                return "Included files: (" + (sourceIncludePattern.isEmpty() ? "None" : (sourceIncludePattern.isAll() ? "All" : sourceIncludePattern.getPattern())) + ")";
            }
            if (object instanceof OrExpressionElement) {
                return "Examine classes:";
            }
            if (object instanceof TestClassElement) {
                return "For classes:";
            }
            if (object instanceof NameConditionElement) {
                return "Where the name matches \"" + ((NameConditionElement)object).getValue() + "\"";
            }
            if (object instanceof TestClassElement.PackageNameConditionElement) {
                return "Where the package matches \"" + ((TestClassElement.PackageNameConditionElement)object).getValue() + "\"";
            }
            if (object instanceof AnnotationNameConditionElement) {
                return "Where one of its annotation's name matches \"" + ((AnnotationNameConditionElement)object).getValue() + "\"";
            }
            if (object instanceof TestClassElement.SuperTypeNameConditionElement) {
                return "Where the superclass name matches \"" + ((TestClassElement.SuperTypeNameConditionElement)object).getValue() + "\"";
            }
            if (object instanceof TestClassElement.AnyConditionElement) {
                return "Of any kind";
            }
            if (object instanceof TestMethodElement.AnyConditionElement) {
                return "Any";
            }
            if (object instanceof TestMethodsElement) {
                return "Test methods are defined as any of:";
            }
            if (object instanceof TestMethodElement) {
                return "Methods matching all the following conditions:";
            }
            if (object instanceof TestMethodElement.ReturnTypeNameConditionElement) {
                return "Where the return type name matches \"" + ((TestMethodElement.ReturnTypeNameConditionElement)object).getValue() + "\"";
            }
            return "??";
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }
    }

    public final class TestPackageRootContentProvider
    implements ITreeContentProvider {
        private TestSourcesElement input;

        public Object[] getElements(Object object) {
            if (this.hasChildren(object)) {
                return this.getChildren(object);
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (object instanceof TreeElement) {
                return ((TreeElement)object).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object object) {
            if (object == this.input) {
                return this.input.getTestPackageRoots().toArray();
            }
            if (object instanceof TestPackageRootElement) {
                ArrayList children = Lists.newArrayList();
                children.add(((TestPackageRootElement)object).getIncludes());
                children.add(((TestPackageRootElement)object).getExcludes());
                children.add(((TestPackageRootElement)object).getExpression());
                return children.toArray();
            }
            if (object instanceof ExpressionElement) {
                return ((ExpressionElement)object).getTestClasses().toArray();
            }
            if (object instanceof TestClassElement) {
                ArrayList children = Lists.newArrayList();
                children.addAll(((TestClassElement)object).getConditions());
                children.add(((TestClassElement)object).getTestMethods());
                return children.toArray();
            }
            if (object instanceof TestMethodsElement) {
                return ((TestMethodsElement)object).getMethods().toArray();
            }
            if (object instanceof TestMethodElement) {
                return ((TestMethodElement)object).getConditions().toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object object) {
            return object == this.input || object instanceof TestPackageRootElement || object instanceof ExpressionElement || object instanceof TestClassElement || object instanceof TestMethodsElement || object instanceof TestMethodElement;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = (TestSourcesElement)newInput;
        }

        public void dispose() {
        }
    }
}

