/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.settings.source.test;

import com.atlassian.clover.spec.instr.test.TestClassSpec;
import java.util.ArrayList;
import java.util.List;
import org.openclover.eclipse.core.projects.settings.source.test.AnnotationNameConditionElement;
import org.openclover.eclipse.core.projects.settings.source.test.ConditionElement;
import org.openclover.eclipse.core.projects.settings.source.test.ExpressionElement;
import org.openclover.eclipse.core.projects.settings.source.test.NameConditionElement;
import org.openclover.eclipse.core.projects.settings.source.test.SpecificConditionElement;
import org.openclover.eclipse.core.projects.settings.source.test.TestMethodElement;
import org.openclover.eclipse.core.projects.settings.source.test.TestMethodsElement;
import org.openclover.eclipse.core.projects.settings.source.test.TreeElement;
import org.openclover.util.Lists;

public class TestClassElement
implements TreeElement {
    private ExpressionElement parent;
    private String pkg;
    private String annotation;
    private String name;
    private String superName;
    private TestMethodsElement testMethods = new TestMethodsElement(this);

    public TestClassElement(ExpressionElement parent) {
        this.parent = parent;
    }

    public String getPackage() {
        return this.pkg;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public TestMethodsElement getTestMethods() {
        return this.testMethods;
    }

    public String getSuper() {
        return this.superName;
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSuper(String superName) {
        this.superName = superName;
    }

    public TestClassSpec toTestClassSpec() {
        TestClassSpec result = new TestClassSpec();
        result.setPackage(this.pkg);
        result.setName(this.name);
        result.setAnnotation(this.annotation);
        result.setSuper(this.superName);
        for (int i = 0; i < this.testMethods.getMethods().size(); ++i) {
            TestMethodElement testMethodElement = this.testMethods.getMethods().get(i);
            result.addConfiguredTestMethod(testMethodElement.toTestMethodSpec());
        }
        return result;
    }

    @Override
    public TreeElement getParent() {
        return this.parent;
    }

    public List<ConditionElement> getConditions() {
        ArrayList<ConditionElement> result = Lists.newArrayList();
        if (this.name != null) {
            result.add(new NameConditionElement(this, this.name));
        }
        if (this.pkg != null) {
            result.add(new PackageNameConditionElement(this, this.pkg));
        }
        if (this.annotation != null) {
            result.add(new AnnotationNameConditionElement(this, this.annotation));
        }
        if (this.superName != null) {
            result.add(new SuperTypeNameConditionElement(this, this.superName));
        }
        if (result.isEmpty()) {
            result.add(new AnyConditionElement(this));
        }
        return result;
    }

    public class AnyConditionElement
    extends org.openclover.eclipse.core.projects.settings.source.test.AnyConditionElement {
        public AnyConditionElement(TreeElement parent) {
            super(parent);
        }
    }

    public class SuperTypeNameConditionElement
    extends SpecificConditionElement {
        public SuperTypeNameConditionElement(TestClassElement parent, String value) {
            super(parent, value);
        }
    }

    public class PackageNameConditionElement
    extends SpecificConditionElement {
        public PackageNameConditionElement(TestClassElement parent, String value) {
            super(parent, value);
        }
    }
}

